<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for imageLogValueType StructType
 * @subpackage Structs
 */
class ImageLogValueType extends AbstractStructBase
{
    /**
     * The photoId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $photoId;
    /**
     * The variantValueId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $variantValueId;
    /**
     * The photoUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $photoUrl;
    /**
     * The errorType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorType;
    /**
     * The errorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The processDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $processDate;
    /**
     * Constructor method for imageLogValueType
     * @uses ImageLogValueType::setPhotoId()
     * @uses ImageLogValueType::setVariantValueId()
     * @uses ImageLogValueType::setPhotoUrl()
     * @uses ImageLogValueType::setErrorType()
     * @uses ImageLogValueType::setErrorMessage()
     * @uses ImageLogValueType::setProcessDate()
     * @param int $photoId
     * @param int $variantValueId
     * @param string $photoUrl
     * @param string $errorType
     * @param string $errorMessage
     * @param string $processDate
     */
    public function __construct($photoId = null, $variantValueId = null, $photoUrl = null, $errorType = null, $errorMessage = null, $processDate = null)
    {
        $this
            ->setPhotoId($photoId)
            ->setVariantValueId($variantValueId)
            ->setPhotoUrl($photoUrl)
            ->setErrorType($errorType)
            ->setErrorMessage($errorMessage)
            ->setProcessDate($processDate);
    }
    /**
     * Get photoId value
     * @return int|null
     */
    public function getPhotoId()
    {
        return $this->photoId;
    }
    /**
     * Set photoId value
     * @param int $photoId
     * @return \StructType\ImageLogValueType
     */
    public function setPhotoId($photoId = null)
    {
        // validation for constraint: int
        if (!is_null($photoId) && !(is_int($photoId) || ctype_digit($photoId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($photoId, true), gettype($photoId)), __LINE__);
        }
        $this->photoId = $photoId;
        return $this;
    }
    /**
     * Get variantValueId value
     * @return int|null
     */
    public function getVariantValueId()
    {
        return $this->variantValueId;
    }
    /**
     * Set variantValueId value
     * @param int $variantValueId
     * @return \StructType\ImageLogValueType
     */
    public function setVariantValueId($variantValueId = null)
    {
        // validation for constraint: int
        if (!is_null($variantValueId) && !(is_int($variantValueId) || ctype_digit($variantValueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($variantValueId, true), gettype($variantValueId)), __LINE__);
        }
        $this->variantValueId = $variantValueId;
        return $this;
    }
    /**
     * Get photoUrl value
     * @return string|null
     */
    public function getPhotoUrl()
    {
        return $this->photoUrl;
    }
    /**
     * Set photoUrl value
     * @param string $photoUrl
     * @return \StructType\ImageLogValueType
     */
    public function setPhotoUrl($photoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($photoUrl) && !is_string($photoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($photoUrl, true), gettype($photoUrl)), __LINE__);
        }
        $this->photoUrl = $photoUrl;
        return $this;
    }
    /**
     * Get errorType value
     * @return string|null
     */
    public function getErrorType()
    {
        return $this->errorType;
    }
    /**
     * Set errorType value
     * @param string $errorType
     * @return \StructType\ImageLogValueType
     */
    public function setErrorType($errorType = null)
    {
        // validation for constraint: string
        if (!is_null($errorType) && !is_string($errorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorType, true), gettype($errorType)), __LINE__);
        }
        $this->errorType = $errorType;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\ImageLogValueType
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get processDate value
     * @return string|null
     */
    public function getProcessDate()
    {
        return $this->processDate;
    }
    /**
     * Set processDate value
     * @param string $processDate
     * @return \StructType\ImageLogValueType
     */
    public function setProcessDate($processDate = null)
    {
        // validation for constraint: string
        if (!is_null($processDate) && !is_string($processDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processDate, true), gettype($processDate)), __LINE__);
        }
        $this->processDate = $processDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ImageLogValueType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
