<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cargoTimeType StructType
 * @subpackage Structs
 */
class CargoTimeType extends AbstractStructBase
{
    /**
     * The days
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $days;
    /**
     * The beforeTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beforeTime;
    /**
     * Constructor method for cargoTimeType
     * @uses CargoTimeType::setDays()
     * @uses CargoTimeType::setBeforeTime()
     * @param string $days
     * @param string $beforeTime
     */
    public function __construct($days = null, $beforeTime = null)
    {
        $this
            ->setDays($days)
            ->setBeforeTime($beforeTime);
    }
    /**
     * Get days value
     * @return string|null
     */
    public function getDays()
    {
        return $this->days;
    }
    /**
     * Set days value
     * @param string $days
     * @return \StructType\CargoTimeType
     */
    public function setDays($days = null)
    {
        // validation for constraint: string
        if (!is_null($days) && !is_string($days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($days, true), gettype($days)), __LINE__);
        }
        $this->days = $days;
        return $this;
    }
    /**
     * Get beforeTime value
     * @return string|null
     */
    public function getBeforeTime()
    {
        return $this->beforeTime;
    }
    /**
     * Set beforeTime value
     * @param string $beforeTime
     * @return \StructType\CargoTimeType
     */
    public function setBeforeTime($beforeTime = null)
    {
        // validation for constraint: string
        if (!is_null($beforeTime) && !is_string($beforeTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beforeTime, true), gettype($beforeTime)), __LINE__);
        }
        $this->beforeTime = $beforeTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CargoTimeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
