<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cargoDetailType StructType
 * @subpackage Structs
 */
class CargoDetailType extends AbstractStructBase
{
    /**
     * The city
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The cargoCompanies
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CargoCompanies
     */
    public $cargoCompanies;
    /**
     * The shippingPayment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingPayment;
    /**
     * The cargoDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cargoDescription;
    /**
     * The shippingWhere
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shippingWhere;
    /**
     * The cargoCompanyDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CargoCompanyDetails
     */
    public $cargoCompanyDetails;
    /**
     * The shippingTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CargoTimeType
     */
    public $shippingTime;
    /**
     * Constructor method for cargoDetailType
     * @uses CargoDetailType::setCity()
     * @uses CargoDetailType::setCargoCompanies()
     * @uses CargoDetailType::setShippingPayment()
     * @uses CargoDetailType::setCargoDescription()
     * @uses CargoDetailType::setShippingWhere()
     * @uses CargoDetailType::setCargoCompanyDetails()
     * @uses CargoDetailType::setShippingTime()
     * @param string $city
     * @param \StructType\CargoCompanies $cargoCompanies
     * @param string $shippingPayment
     * @param string $cargoDescription
     * @param string $shippingWhere
     * @param \StructType\CargoCompanyDetails $cargoCompanyDetails
     * @param \StructType\CargoTimeType $shippingTime
     */
    public function __construct($city = null, \StructType\CargoCompanies $cargoCompanies = null, $shippingPayment = null, $cargoDescription = null, $shippingWhere = null, \StructType\CargoCompanyDetails $cargoCompanyDetails = null, \StructType\CargoTimeType $shippingTime = null)
    {
        $this
            ->setCity($city)
            ->setCargoCompanies($cargoCompanies)
            ->setShippingPayment($shippingPayment)
            ->setCargoDescription($cargoDescription)
            ->setShippingWhere($shippingWhere)
            ->setCargoCompanyDetails($cargoCompanyDetails)
            ->setShippingTime($shippingTime);
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\CargoDetailType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get cargoCompanies value
     * @return \StructType\CargoCompanies|null
     */
    public function getCargoCompanies()
    {
        return $this->cargoCompanies;
    }
    /**
     * Set cargoCompanies value
     * @param \StructType\CargoCompanies $cargoCompanies
     * @return \StructType\CargoDetailType
     */
    public function setCargoCompanies(\StructType\CargoCompanies $cargoCompanies = null)
    {
        $this->cargoCompanies = $cargoCompanies;
        return $this;
    }
    /**
     * Get shippingPayment value
     * @return string|null
     */
    public function getShippingPayment()
    {
        return $this->shippingPayment;
    }
    /**
     * Set shippingPayment value
     * @param string $shippingPayment
     * @return \StructType\CargoDetailType
     */
    public function setShippingPayment($shippingPayment = null)
    {
        // validation for constraint: string
        if (!is_null($shippingPayment) && !is_string($shippingPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingPayment, true), gettype($shippingPayment)), __LINE__);
        }
        $this->shippingPayment = $shippingPayment;
        return $this;
    }
    /**
     * Get cargoDescription value
     * @return string|null
     */
    public function getCargoDescription()
    {
        return $this->cargoDescription;
    }
    /**
     * Set cargoDescription value
     * @param string $cargoDescription
     * @return \StructType\CargoDetailType
     */
    public function setCargoDescription($cargoDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cargoDescription) && !is_string($cargoDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoDescription, true), gettype($cargoDescription)), __LINE__);
        }
        $this->cargoDescription = $cargoDescription;
        return $this;
    }
    /**
     * Get shippingWhere value
     * @return string|null
     */
    public function getShippingWhere()
    {
        return $this->shippingWhere;
    }
    /**
     * Set shippingWhere value
     * @param string $shippingWhere
     * @return \StructType\CargoDetailType
     */
    public function setShippingWhere($shippingWhere = null)
    {
        // validation for constraint: string
        if (!is_null($shippingWhere) && !is_string($shippingWhere)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingWhere, true), gettype($shippingWhere)), __LINE__);
        }
        $this->shippingWhere = $shippingWhere;
        return $this;
    }
    /**
     * Get cargoCompanyDetails value
     * @return \StructType\CargoCompanyDetails|null
     */
    public function getCargoCompanyDetails()
    {
        return $this->cargoCompanyDetails;
    }
    /**
     * Set cargoCompanyDetails value
     * @param \StructType\CargoCompanyDetails $cargoCompanyDetails
     * @return \StructType\CargoDetailType
     */
    public function setCargoCompanyDetails(\StructType\CargoCompanyDetails $cargoCompanyDetails = null)
    {
        $this->cargoCompanyDetails = $cargoCompanyDetails;
        return $this;
    }
    /**
     * Get shippingTime value
     * @return \StructType\CargoTimeType|null
     */
    public function getShippingTime()
    {
        return $this->shippingTime;
    }
    /**
     * Set shippingTime value
     * @param \StructType\CargoTimeType $shippingTime
     * @return \StructType\CargoDetailType
     */
    public function setShippingTime(\StructType\CargoTimeType $shippingTime = null)
    {
        $this->shippingTime = $shippingTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CargoDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
