<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cargoCompanies StructType
 * @subpackage Structs
 */
class CargoCompanies extends AbstractStructBase
{
    /**
     * The cargoCompany
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $cargoCompany;
    /**
     * Constructor method for cargoCompanies
     * @uses CargoCompanies::setCargoCompany()
     * @param string[] $cargoCompany
     */
    public function __construct(array $cargoCompany = array())
    {
        $this
            ->setCargoCompany($cargoCompany);
    }
    /**
     * Get cargoCompany value
     * @return string[]|null
     */
    public function getCargoCompany()
    {
        return $this->cargoCompany;
    }
    /**
     * This method is responsible for validating the values passed to the setCargoCompany method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCargoCompany method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCargoCompanyForArrayConstraintsFromSetCargoCompany(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cargoCompaniesCargoCompanyItem) {
            // validation for constraint: itemType
            if (!is_string($cargoCompaniesCargoCompanyItem)) {
                $invalidValues[] = is_object($cargoCompaniesCargoCompanyItem) ? get_class($cargoCompaniesCargoCompanyItem) : sprintf('%s(%s)', gettype($cargoCompaniesCargoCompanyItem), var_export($cargoCompaniesCargoCompanyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The cargoCompany property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set cargoCompany value
     * @throws \InvalidArgumentException
     * @param string[] $cargoCompany
     * @return \StructType\CargoCompanies
     */
    public function setCargoCompany(array $cargoCompany = array())
    {
        // validation for constraint: array
        if ('' !== ($cargoCompanyArrayErrorMessage = self::validateCargoCompanyForArrayConstraintsFromSetCargoCompany($cargoCompany))) {
            throw new \InvalidArgumentException($cargoCompanyArrayErrorMessage, __LINE__);
        }
        $this->cargoCompany = $cargoCompany;
        return $this;
    }
    /**
     * Add item to cargoCompany value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CargoCompanies
     */
    public function addToCargoCompany($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The cargoCompany property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->cargoCompany[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CargoCompanies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
