<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert ServiceType
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named insertProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $itemId
     * @param \StructType\ProductType $product
     * @param string $forceToSpecEntry
     * @param string $nextDateOption
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function insertProduct($apiKey, $sign, $time, $itemId, \StructType\ProductType $product, $forceToSpecEntry, $nextDateOption, $lang)
    {
        try {
            $this->setResult(self::getSoapClient()->insertProduct($apiKey, $sign, $time, $itemId, $product, $forceToSpecEntry, $nextDateOption, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named insertProductWithNewCargoDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $itemId
     * @param \StructType\ProductType $product
     * @param string $forceToSpecEntry
     * @param string $nextDateOption
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function insertProductWithNewCargoDetail($apiKey, $sign, $time, $itemId, \StructType\ProductType $product, $forceToSpecEntry, $nextDateOption, $lang)
    {
        try {
            $this->setResult(self::getSoapClient()->insertProductWithNewCargoDetail($apiKey, $sign, $time, $itemId, $product, $forceToSpecEntry, $nextDateOption, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named insertRetailProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $itemId
     * @param \StructType\ProductType $product
     * @param string $forceToSpecEntry
     * @param string $nextDateOption
     * @param string $lang
     * @return \StructType\ProductServiceRetailResponse|bool
     */
    public function insertRetailProduct($apiKey, $sign, $time, $itemId, \StructType\ProductType $product, $forceToSpecEntry, $nextDateOption, $lang)
    {
        try {
            $this->setResult(self::getSoapClient()->insertRetailProduct($apiKey, $sign, $time, $itemId, $product, $forceToSpecEntry, $nextDateOption, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * insertRetailProductWithNewCargoDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $itemId
     * @param \StructType\ProductType $product
     * @param string $forceToSpecEntry
     * @param string $nextDateOption
     * @param string $lang
     * @return \StructType\ProductServiceRetailResponse|bool
     */
    public function insertRetailProductWithNewCargoDetail($apiKey, $sign, $time, $itemId, \StructType\ProductType $product, $forceToSpecEntry, $nextDateOption, $lang)
    {
        try {
            $this->setResult(self::getSoapClient()->insertRetailProductWithNewCargoDetail($apiKey, $sign, $time, $itemId, $product, $forceToSpecEntry, $nextDateOption, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProductServiceResponse|\StructType\ProductServiceRetailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
