<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Finish ServiceType
 * @subpackage Services
 */
class Finish extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named finishEarly
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \ArrayType\IntArray $productIdList
     * @param \ArrayType\StringArray $itemIdList
     * @param string $lang
     * @return \StructType\ProductServiceIdResponse|bool
     */
    public function finishEarly($apiKey, $sign, $time, \ArrayType\IntArray $productIdList, \ArrayType\StringArray $itemIdList, $lang)
    {
        try {
            $this->setResult(self::getSoapClient()->finishEarly($apiKey, $sign, $time, $productIdList, $itemIdList, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named finishEarlyProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \ArrayType\IntArray $productIdList
     * @param \ArrayType\StringArray $itemIdList
     * @param string $lang
     * @return \StructType\ProductServiceProcessResponse|bool
     */
    public function finishEarlyProducts($apiKey, $sign, $time, \ArrayType\IntArray $productIdList, \ArrayType\StringArray $itemIdList, $lang)
    {
        try {
            $this->setResult(self::getSoapClient()->finishEarlyProducts($apiKey, $sign, $time, $productIdList, $itemIdList, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProductServiceIdResponse|\StructType\ProductServiceProcessResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
