<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelContents StructType
 * @subpackage Structs
 */
class ParcelContents extends AbstractStructBase
{
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ContentData[]
     */
    public $Item;
    /**
     * Constructor method for ParcelContents
     * @uses ParcelContents::setItem()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ContentData[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get Item value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ContentData[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parcelContentsItemItem) {
            // validation for constraint: itemType
            if (!$parcelContentsItemItem instanceof \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ContentData) {
                $invalidValues[] = is_object($parcelContentsItemItem) ? get_class($parcelContentsItemItem) : sprintf('%s(%s)', gettype($parcelContentsItemItem), var_export($parcelContentsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ContentData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ContentData[] $item
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new \InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ContentData $item
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents
     */
    public function addToItem(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ContentData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ContentData) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ContentData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
