<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompletedShipment StructType
 * @subpackage Structs
 */
class CompletedShipment extends AbstractStructBase
{
    /**
     * The ShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The OutBoundShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OutBoundShipmentNumber;
    /**
     * The InBoundShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InBoundShipmentNumber;
    /**
     * The PartnerNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PartnerNumber;
    /**
     * Constructor method for CompletedShipment
     * @uses CompletedShipment::setShipmentNumber()
     * @uses CompletedShipment::setOutBoundShipmentNumber()
     * @uses CompletedShipment::setInBoundShipmentNumber()
     * @uses CompletedShipment::setPartnerNumber()
     * @param string $shipmentNumber
     * @param string $outBoundShipmentNumber
     * @param string $inBoundShipmentNumber
     * @param string $partnerNumber
     */
    public function __construct($shipmentNumber = null, $outBoundShipmentNumber = null, $inBoundShipmentNumber = null, $partnerNumber = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setOutBoundShipmentNumber($outBoundShipmentNumber)
            ->setInBoundShipmentNumber($inBoundShipmentNumber)
            ->setPartnerNumber($partnerNumber);
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipment
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get OutBoundShipmentNumber value
     * @return string|null
     */
    public function getOutBoundShipmentNumber()
    {
        return $this->OutBoundShipmentNumber;
    }
    /**
     * Set OutBoundShipmentNumber value
     * @param string $outBoundShipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipment
     */
    public function setOutBoundShipmentNumber($outBoundShipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($outBoundShipmentNumber) && !is_string($outBoundShipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outBoundShipmentNumber, true), gettype($outBoundShipmentNumber)), __LINE__);
        }
        $this->OutBoundShipmentNumber = $outBoundShipmentNumber;
        return $this;
    }
    /**
     * Get InBoundShipmentNumber value
     * @return string|null
     */
    public function getInBoundShipmentNumber()
    {
        return $this->InBoundShipmentNumber;
    }
    /**
     * Set InBoundShipmentNumber value
     * @param string $inBoundShipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipment
     */
    public function setInBoundShipmentNumber($inBoundShipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($inBoundShipmentNumber) && !is_string($inBoundShipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inBoundShipmentNumber, true), gettype($inBoundShipmentNumber)), __LINE__);
        }
        $this->InBoundShipmentNumber = $inBoundShipmentNumber;
        return $this;
    }
    /**
     * Get PartnerNumber value
     * @return string|null
     */
    public function getPartnerNumber()
    {
        return $this->PartnerNumber;
    }
    /**
     * Set PartnerNumber value
     * @param string $partnerNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipment
     */
    public function setPartnerNumber($partnerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($partnerNumber) && !is_string($partnerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerNumber, true), gettype($partnerNumber)), __LINE__);
        }
        $this->PartnerNumber = $partnerNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
