<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Return ServiceType
 * @subpackage Services
 */
class _Return extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named returnShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ReturnShipmentRequest $returnShipmentRequest
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ReturnShipmentReply|bool
     */
    public function returnShipment(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ReturnShipmentRequest $returnShipmentRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->returnShipment($returnShipmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ReturnShipmentReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
