<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreateShipmentRequest $createShipmentRequest
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreateShipmentReply|bool
     */
    public function createShipment(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreateShipmentRequest $createShipmentRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->createShipment($createShipmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createPrint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreatePrintRequest $createPrintRequest
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreatePrintReply|bool
     */
    public function createPrint(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreatePrintRequest $createPrintRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->createPrint($createPrintRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createManifest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreateManifestRequest $createManifestRequest
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreateManifestReply|bool
     */
    public function createManifest(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreateManifestRequest $createManifestRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->createManifest($createManifestRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreateManifestReply|\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreatePrintReply|\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreateShipmentReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
