<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \app\Service\ShipmentHandler\ParcelForce\ExpressLink\ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\ServiceType\Create($options);
/**
 * Sample call for createShipment operation/method
 */
if ($create->createShipment(new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreateShipmentRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createPrint operation/method
 */
if ($create->createPrint(new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreatePrintRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createManifest operation/method
 */
if ($create->createManifest(new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CreateManifestRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Print ServiceType
 */
$print = new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\ServiceType\_Print($options);
/**
 * Sample call for printLabel operation/method
 */
if ($print->printLabel(new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintLabelRequest()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Sample call for printDocument operation/method
 */
if ($print->printDocument(new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintDocumentRequest()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Sample call for printManifest operation/method
 */
if ($print->printManifest(new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintManifestRequest()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Samples for Return ServiceType
 */
$return = new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\ServiceType\_Return($options);
/**
 * Sample call for returnShipment operation/method
 */
if ($return->returnShipment(new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ReturnShipmentRequest()) !== false) {
    print_r($return->getResult());
} else {
    print_r($return->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\ServiceType\Find($options);
/**
 * Sample call for Find operation/method
 */
if ($find->Find(new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\FindRequest()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for CCR ServiceType
 */
$cCR = new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\ServiceType\CCR($options);
/**
 * Sample call for CCReserve operation/method
 */
if ($cCR->CCReserve(new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CCReserveRequest()) !== false) {
    print_r($cCR->getResult());
} else {
    print_r($cCR->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\ServiceType\Cancel($options);
/**
 * Sample call for CancelShipment operation/method
 */
if ($cancel->CancelShipment(new \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CancelShipmentRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
