<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SafePlaceList StructType
 * @subpackage Structs
 */
class SafePlaceList extends AbstractStructBase
{
    /**
     * The SafePlace
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SafePlace;
    /**
     * Constructor method for SafePlaceList
     * @uses SafePlaceList::setSafePlace()
     * @param string[] $safePlace
     */
    public function __construct(array $safePlace = array())
    {
        $this
            ->setSafePlace($safePlace);
    }
    /**
     * Get SafePlace value
     * @return string[]|null
     */
    public function getSafePlace()
    {
        return $this->SafePlace;
    }
    /**
     * This method is responsible for validating the values passed to the setSafePlace method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSafePlace method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSafePlaceForArrayConstraintsFromSetSafePlace(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $safePlaceListSafePlaceItem) {
            // validation for constraint: itemType
            if (!is_string($safePlaceListSafePlaceItem)) {
                $invalidValues[] = is_object($safePlaceListSafePlaceItem) ? get_class($safePlaceListSafePlaceItem) : sprintf('%s(%s)', gettype($safePlaceListSafePlaceItem), var_export($safePlaceListSafePlaceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SafePlace property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SafePlace value
     * @throws \InvalidArgumentException
     * @param string[] $safePlace
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\SafePlaceList
     */
    public function setSafePlace(array $safePlace = array())
    {
        // validation for constraint: array
        if ('' !== ($safePlaceArrayErrorMessage = self::validateSafePlaceForArrayConstraintsFromSetSafePlace($safePlace))) {
            throw new \InvalidArgumentException($safePlaceArrayErrorMessage, __LINE__);
        }
        $this->SafePlace = $safePlace;
        return $this;
    }
    /**
     * Add item to SafePlace value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\SafePlaceList
     */
    public function addToSafePlace($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SafePlace property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SafePlace[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\SafePlaceList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
