<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintManifestRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ns:PrintManifestRequest
 * @subpackage Structs
 */
class PrintManifestRequest extends BaseRequest
{
    /**
     * The ManifestNumber
     * @var string
     */
    public $ManifestNumber;
    /**
     * The PrintFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PrintFormat;
    /**
     * Constructor method for PrintManifestRequest
     * @uses PrintManifestRequest::setManifestNumber()
     * @uses PrintManifestRequest::setPrintFormat()
     * @param string $manifestNumber
     * @param string $printFormat
     */
    public function __construct($manifestNumber = null, $printFormat = null)
    {
        $this
            ->setManifestNumber($manifestNumber)
            ->setPrintFormat($printFormat);
    }
    /**
     * Get ManifestNumber value
     * @return string|null
     */
    public function getManifestNumber()
    {
        return $this->ManifestNumber;
    }
    /**
     * Set ManifestNumber value
     * @param string $manifestNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintManifestRequest
     */
    public function setManifestNumber($manifestNumber = null)
    {
        // validation for constraint: string
        if (!is_null($manifestNumber) && !is_string($manifestNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestNumber, true), gettype($manifestNumber)), __LINE__);
        }
        $this->ManifestNumber = $manifestNumber;
        return $this;
    }
    /**
     * Get PrintFormat value
     * @return string|null
     */
    public function getPrintFormat()
    {
        return $this->PrintFormat;
    }
    /**
     * Set PrintFormat value
     * @param string $printFormat
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintManifestRequest
     */
    public function setPrintFormat($printFormat = null)
    {
        // validation for constraint: string
        if (!is_null($printFormat) && !is_string($printFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printFormat, true), gettype($printFormat)), __LINE__);
        }
        $this->PrintFormat = $printFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintManifestRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
