<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintLabelReply StructType
 * Meta informations extracted from the WSDL
 * - type: ns:PrintLabelReply
 * @subpackage Structs
 */
class PrintLabelReply extends BaseReply
{
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Document
     */
    public $Label;
    /**
     * The LabelData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ShipmentLabelData
     */
    public $LabelData;
    /**
     * The PartnerCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PartnerCode;
    /**
     * Constructor method for PrintLabelReply
     * @uses PrintLabelReply::setLabel()
     * @uses PrintLabelReply::setLabelData()
     * @uses PrintLabelReply::setPartnerCode()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Document $label
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ShipmentLabelData $labelData
     * @param string $partnerCode
     */
    public function __construct(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Document $label = null, \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ShipmentLabelData $labelData = null, $partnerCode = null)
    {
        $this
            ->setLabel($label)
            ->setLabelData($labelData)
            ->setPartnerCode($partnerCode);
    }
    /**
     * Get Label value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Document|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Document $label
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintLabelReply
     */
    public function setLabel(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Document $label = null)
    {
        $this->Label = $label;
        return $this;
    }
    /**
     * Get LabelData value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ShipmentLabelData|null
     */
    public function getLabelData()
    {
        return $this->LabelData;
    }
    /**
     * Set LabelData value
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ShipmentLabelData $labelData
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintLabelReply
     */
    public function setLabelData(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ShipmentLabelData $labelData = null)
    {
        $this->LabelData = $labelData;
        return $this;
    }
    /**
     * Get PartnerCode value
     * @return string|null
     */
    public function getPartnerCode()
    {
        return $this->PartnerCode;
    }
    /**
     * Set PartnerCode value
     * @param string $partnerCode
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintLabelReply
     */
    public function setPartnerCode($partnerCode = null)
    {
        // validation for constraint: string
        if (!is_null($partnerCode) && !is_string($partnerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerCode, true), gettype($partnerCode)), __LINE__);
        }
        $this->PartnerCode = $partnerCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintLabelReply
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
