<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelLabelData StructType
 * @subpackage Structs
 */
class ParcelLabelData extends AbstractStructBase
{
    /**
     * The ParcelNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ParcelNumber;
    /**
     * The ShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The JourneyLeg
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $JourneyLeg;
    /**
     * The LabelData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\LabelData
     */
    public $LabelData;
    /**
     * The Barcodes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Barcodes
     */
    public $Barcodes;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Images
     */
    public $Images;
    /**
     * The ParcelContents
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents[]
     */
    public $ParcelContents;
    /**
     * Constructor method for ParcelLabelData
     * @uses ParcelLabelData::setParcelNumber()
     * @uses ParcelLabelData::setShipmentNumber()
     * @uses ParcelLabelData::setJourneyLeg()
     * @uses ParcelLabelData::setLabelData()
     * @uses ParcelLabelData::setBarcodes()
     * @uses ParcelLabelData::setImages()
     * @uses ParcelLabelData::setParcelContents()
     * @param string $parcelNumber
     * @param string $shipmentNumber
     * @param string $journeyLeg
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\LabelData $labelData
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Barcodes $barcodes
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Images $images
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents[] $parcelContents
     */
    public function __construct($parcelNumber = null, $shipmentNumber = null, $journeyLeg = null, \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\LabelData $labelData = null, \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Barcodes $barcodes = null, \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Images $images = null, array $parcelContents = array())
    {
        $this
            ->setParcelNumber($parcelNumber)
            ->setShipmentNumber($shipmentNumber)
            ->setJourneyLeg($journeyLeg)
            ->setLabelData($labelData)
            ->setBarcodes($barcodes)
            ->setImages($images)
            ->setParcelContents($parcelContents);
    }
    /**
     * Get ParcelNumber value
     * @return string|null
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param string $parcelNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelLabelData
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($parcelNumber) && !is_string($parcelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelLabelData
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get JourneyLeg value
     * @return string|null
     */
    public function getJourneyLeg()
    {
        return $this->JourneyLeg;
    }
    /**
     * Set JourneyLeg value
     * @param string $journeyLeg
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelLabelData
     */
    public function setJourneyLeg($journeyLeg = null)
    {
        // validation for constraint: string
        if (!is_null($journeyLeg) && !is_string($journeyLeg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journeyLeg, true), gettype($journeyLeg)), __LINE__);
        }
        $this->JourneyLeg = $journeyLeg;
        return $this;
    }
    /**
     * Get LabelData value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\LabelData|null
     */
    public function getLabelData()
    {
        return $this->LabelData;
    }
    /**
     * Set LabelData value
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\LabelData $labelData
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelLabelData
     */
    public function setLabelData(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\LabelData $labelData = null)
    {
        $this->LabelData = $labelData;
        return $this;
    }
    /**
     * Get Barcodes value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Barcodes|null
     */
    public function getBarcodes()
    {
        return $this->Barcodes;
    }
    /**
     * Set Barcodes value
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Barcodes $barcodes
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelLabelData
     */
    public function setBarcodes(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Barcodes $barcodes = null)
    {
        $this->Barcodes = $barcodes;
        return $this;
    }
    /**
     * Get Images value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Images|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Images $images
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelLabelData
     */
    public function setImages(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Images $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get ParcelContents value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents[]|null
     */
    public function getParcelContents()
    {
        return $this->ParcelContents;
    }
    /**
     * This method is responsible for validating the values passed to the setParcelContents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcelContents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelContentsForArrayConstraintsFromSetParcelContents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parcelLabelDataParcelContentsItem) {
            // validation for constraint: itemType
            if (!$parcelLabelDataParcelContentsItem instanceof \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents) {
                $invalidValues[] = is_object($parcelLabelDataParcelContentsItem) ? get_class($parcelLabelDataParcelContentsItem) : sprintf('%s(%s)', gettype($parcelLabelDataParcelContentsItem), var_export($parcelLabelDataParcelContentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ParcelContents property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ParcelContents value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents[] $parcelContents
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelLabelData
     */
    public function setParcelContents(array $parcelContents = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelContentsArrayErrorMessage = self::validateParcelContentsForArrayConstraintsFromSetParcelContents($parcelContents))) {
            throw new \InvalidArgumentException($parcelContentsArrayErrorMessage, __LINE__);
        }
        $this->ParcelContents = $parcelContents;
        return $this;
    }
    /**
     * Add item to ParcelContents value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents $item
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelLabelData
     */
    public function addToParcelContents(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents) {
            throw new \InvalidArgumentException(sprintf('The ParcelContents property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelContents, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ParcelContents[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\ParcelLabelData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
