<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InternationalInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Only for international shipments
 * @subpackage Structs
 */
class InternationalInfo extends AbstractStructBase
{
    /**
     * The Parcels
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Parcels
     */
    public $Parcels;
    /**
     * The ExporterCustomsReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExporterCustomsReference;
    /**
     * The RecipientImporterVatNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RecipientImporterVatNo;
    /**
     * The OriginalExportShipmentNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OriginalExportShipmentNo;
    /**
     * The DocumentsOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DocumentsOnly;
    /**
     * The DocumentsDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentsDescription;
    /**
     * The ValueUnder200USDollars
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ValueUnder200USDollars;
    /**
     * The ShipmentDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentDescription;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * The InvoiceDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceDate;
    /**
     * The TermsOfDelivery
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TermsOfDelivery;
    /**
     * The PurchaseOrderRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PurchaseOrderRef;
    /**
     * Constructor method for InternationalInfo
     * @uses InternationalInfo::setParcels()
     * @uses InternationalInfo::setExporterCustomsReference()
     * @uses InternationalInfo::setRecipientImporterVatNo()
     * @uses InternationalInfo::setOriginalExportShipmentNo()
     * @uses InternationalInfo::setDocumentsOnly()
     * @uses InternationalInfo::setDocumentsDescription()
     * @uses InternationalInfo::setValueUnder200USDollars()
     * @uses InternationalInfo::setShipmentDescription()
     * @uses InternationalInfo::setComments()
     * @uses InternationalInfo::setInvoiceDate()
     * @uses InternationalInfo::setTermsOfDelivery()
     * @uses InternationalInfo::setPurchaseOrderRef()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Parcels $parcels
     * @param string $exporterCustomsReference
     * @param string $recipientImporterVatNo
     * @param string $originalExportShipmentNo
     * @param bool $documentsOnly
     * @param string $documentsDescription
     * @param bool $valueUnder200USDollars
     * @param string $shipmentDescription
     * @param string $comments
     * @param string $invoiceDate
     * @param string $termsOfDelivery
     * @param string $purchaseOrderRef
     */
    public function __construct(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Parcels $parcels = null, $exporterCustomsReference = null, $recipientImporterVatNo = null, $originalExportShipmentNo = null, $documentsOnly = null, $documentsDescription = null, $valueUnder200USDollars = null, $shipmentDescription = null, $comments = null, $invoiceDate = null, $termsOfDelivery = null, $purchaseOrderRef = null)
    {
        $this
            ->setParcels($parcels)
            ->setExporterCustomsReference($exporterCustomsReference)
            ->setRecipientImporterVatNo($recipientImporterVatNo)
            ->setOriginalExportShipmentNo($originalExportShipmentNo)
            ->setDocumentsOnly($documentsOnly)
            ->setDocumentsDescription($documentsDescription)
            ->setValueUnder200USDollars($valueUnder200USDollars)
            ->setShipmentDescription($shipmentDescription)
            ->setComments($comments)
            ->setInvoiceDate($invoiceDate)
            ->setTermsOfDelivery($termsOfDelivery)
            ->setPurchaseOrderRef($purchaseOrderRef);
    }
    /**
     * Get Parcels value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Parcels|null
     */
    public function getParcels()
    {
        return $this->Parcels;
    }
    /**
     * Set Parcels value
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Parcels $parcels
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setParcels(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Parcels $parcels = null)
    {
        $this->Parcels = $parcels;
        return $this;
    }
    /**
     * Get ExporterCustomsReference value
     * @return string|null
     */
    public function getExporterCustomsReference()
    {
        return $this->ExporterCustomsReference;
    }
    /**
     * Set ExporterCustomsReference value
     * @param string $exporterCustomsReference
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setExporterCustomsReference($exporterCustomsReference = null)
    {
        // validation for constraint: string
        if (!is_null($exporterCustomsReference) && !is_string($exporterCustomsReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exporterCustomsReference, true), gettype($exporterCustomsReference)), __LINE__);
        }
        $this->ExporterCustomsReference = $exporterCustomsReference;
        return $this;
    }
    /**
     * Get RecipientImporterVatNo value
     * @return string|null
     */
    public function getRecipientImporterVatNo()
    {
        return $this->RecipientImporterVatNo;
    }
    /**
     * Set RecipientImporterVatNo value
     * @param string $recipientImporterVatNo
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setRecipientImporterVatNo($recipientImporterVatNo = null)
    {
        // validation for constraint: string
        if (!is_null($recipientImporterVatNo) && !is_string($recipientImporterVatNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recipientImporterVatNo, true), gettype($recipientImporterVatNo)), __LINE__);
        }
        $this->RecipientImporterVatNo = $recipientImporterVatNo;
        return $this;
    }
    /**
     * Get OriginalExportShipmentNo value
     * @return string|null
     */
    public function getOriginalExportShipmentNo()
    {
        return $this->OriginalExportShipmentNo;
    }
    /**
     * Set OriginalExportShipmentNo value
     * @param string $originalExportShipmentNo
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setOriginalExportShipmentNo($originalExportShipmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($originalExportShipmentNo) && !is_string($originalExportShipmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalExportShipmentNo, true), gettype($originalExportShipmentNo)), __LINE__);
        }
        $this->OriginalExportShipmentNo = $originalExportShipmentNo;
        return $this;
    }
    /**
     * Get DocumentsOnly value
     * @return bool|null
     */
    public function getDocumentsOnly()
    {
        return $this->DocumentsOnly;
    }
    /**
     * Set DocumentsOnly value
     * @param bool $documentsOnly
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setDocumentsOnly($documentsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($documentsOnly) && !is_bool($documentsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($documentsOnly, true), gettype($documentsOnly)), __LINE__);
        }
        $this->DocumentsOnly = $documentsOnly;
        return $this;
    }
    /**
     * Get DocumentsDescription value
     * @return string|null
     */
    public function getDocumentsDescription()
    {
        return $this->DocumentsDescription;
    }
    /**
     * Set DocumentsDescription value
     * @param string $documentsDescription
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setDocumentsDescription($documentsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($documentsDescription) && !is_string($documentsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentsDescription, true), gettype($documentsDescription)), __LINE__);
        }
        $this->DocumentsDescription = $documentsDescription;
        return $this;
    }
    /**
     * Get ValueUnder200USDollars value
     * @return bool|null
     */
    public function getValueUnder200USDollars()
    {
        return $this->ValueUnder200USDollars;
    }
    /**
     * Set ValueUnder200USDollars value
     * @param bool $valueUnder200USDollars
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setValueUnder200USDollars($valueUnder200USDollars = null)
    {
        // validation for constraint: boolean
        if (!is_null($valueUnder200USDollars) && !is_bool($valueUnder200USDollars)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valueUnder200USDollars, true), gettype($valueUnder200USDollars)), __LINE__);
        }
        $this->ValueUnder200USDollars = $valueUnder200USDollars;
        return $this;
    }
    /**
     * Get ShipmentDescription value
     * @return string|null
     */
    public function getShipmentDescription()
    {
        return $this->ShipmentDescription;
    }
    /**
     * Set ShipmentDescription value
     * @param string $shipmentDescription
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setShipmentDescription($shipmentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDescription) && !is_string($shipmentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDescription, true), gettype($shipmentDescription)), __LINE__);
        }
        $this->ShipmentDescription = $shipmentDescription;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string|null
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get TermsOfDelivery value
     * @return string|null
     */
    public function getTermsOfDelivery()
    {
        return $this->TermsOfDelivery;
    }
    /**
     * Set TermsOfDelivery value
     * @param string $termsOfDelivery
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setTermsOfDelivery($termsOfDelivery = null)
    {
        // validation for constraint: string
        if (!is_null($termsOfDelivery) && !is_string($termsOfDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($termsOfDelivery, true), gettype($termsOfDelivery)), __LINE__);
        }
        $this->TermsOfDelivery = $termsOfDelivery;
        return $this;
    }
    /**
     * Get PurchaseOrderRef value
     * @return string|null
     */
    public function getPurchaseOrderRef()
    {
        return $this->PurchaseOrderRef;
    }
    /**
     * Set PurchaseOrderRef value
     * @param string $purchaseOrderRef
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public function setPurchaseOrderRef($purchaseOrderRef = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrderRef) && !is_string($purchaseOrderRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseOrderRef, true), gettype($purchaseOrderRef)), __LINE__);
        }
        $this->PurchaseOrderRef = $purchaseOrderRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InternationalInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
