<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Alert StructType
 * @subpackage Structs
 */
class Alert extends AbstractStructBase
{
    /**
     * The Code
     * @var int
     */
    public $Code;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Alert
     * @uses Alert::setCode()
     * @uses Alert::setMessage()
     * @uses Alert::setType()
     * @param int $code
     * @param string $message
     * @param string $type
     */
    public function __construct($code = null, $message = null, $type = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message)
            ->setType($type);
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Alert
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Alert
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \app\Service\ShipmentHandler\ParcelForce\ExpressLink\EnumType\AlertType::valueIsValid()
     * @uses \app\Service\ShipmentHandler\ParcelForce\ExpressLink\EnumType\AlertType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Alert
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\app\Service\ShipmentHandler\ParcelForce\ExpressLink\EnumType\AlertType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \app\Service\ShipmentHandler\ParcelForce\ExpressLink\EnumType\AlertType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \app\Service\ShipmentHandler\ParcelForce\ExpressLink\EnumType\AlertType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Alert
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
