<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\EnumType;

/**
 * This class stands for PrintType EnumType
 * @subpackage Enumerations
 */
class PrintType
{
    /**
     * Constant for value 'ALL_PARCELS'
     * @return string 'ALL_PARCELS'
     */
    const VALUE_ALL_PARCELS = 'ALL_PARCELS';
    /**
     * Constant for value 'SINGLE_PARCEL'
     * @return string 'SINGLE_PARCEL'
     */
    const VALUE_SINGLE_PARCEL = 'SINGLE_PARCEL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL_PARCELS
     * @uses self::VALUE_SINGLE_PARCEL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL_PARCELS,
            self::VALUE_SINGLE_PARCEL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
