<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notifications StructType
 * @subpackage Structs
 */
class Notifications extends AbstractStructBase
{
    /**
     * The NotificationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $NotificationType;
    /**
     * Constructor method for Notifications
     * @uses Notifications::setNotificationType()
     * @param string[] $notificationType
     */
    public function __construct(array $notificationType = array())
    {
        $this
            ->setNotificationType($notificationType);
    }
    /**
     * Get NotificationType value
     * @return string[]
     */
    public function getNotificationType()
    {
        return $this->NotificationType;
    }
    /**
     * This method is responsible for validating the values passed to the setNotificationType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotificationType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationTypeForArrayConstraintsFromSetNotificationType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $notificationsNotificationTypeItem) {
            // validation for constraint: itemType
            if (!is_string($notificationsNotificationTypeItem)) {
                $invalidValues[] = is_object($notificationsNotificationTypeItem) ? get_class($notificationsNotificationTypeItem) : sprintf('%s(%s)', gettype($notificationsNotificationTypeItem), var_export($notificationsNotificationTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NotificationType property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NotificationType value
     * @throws \InvalidArgumentException
     * @param string[] $notificationType
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Notifications
     */
    public function setNotificationType(array $notificationType = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationTypeArrayErrorMessage = self::validateNotificationTypeForArrayConstraintsFromSetNotificationType($notificationType))) {
            throw new \InvalidArgumentException($notificationTypeArrayErrorMessage, __LINE__);
        }
        $this->NotificationType = $notificationType;
        return $this;
    }
    /**
     * Add item to NotificationType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Notifications
     */
    public function addToNotificationType($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NotificationType property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NotificationType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Notifications
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
