<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InBoundDetails StructType
 * @subpackage Structs
 */
class InBoundDetails extends AbstractStructBase
{
    /**
     * The ContractNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ContractNumber;
    /**
     * The ServiceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ServiceCode;
    /**
     * The TotalShipmentWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TotalShipmentWeight;
    /**
     * The Enhancement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Enhancement
     */
    public $Enhancement;
    /**
     * The ReferenceNumber1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber1;
    /**
     * The ReferenceNumber2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber2;
    /**
     * The ReferenceNumber3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber3;
    /**
     * The ReferenceNumber4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber4;
    /**
     * The ReferenceNumber5
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber5;
    /**
     * The SpecialInstructions1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstructions1;
    /**
     * The SpecialInstructions2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstructions2;
    /**
     * The SpecialInstructions3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstructions3;
    /**
     * The SpecialInstructions4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstructions4;
    /**
     * Constructor method for InBoundDetails
     * @uses InBoundDetails::setContractNumber()
     * @uses InBoundDetails::setServiceCode()
     * @uses InBoundDetails::setTotalShipmentWeight()
     * @uses InBoundDetails::setEnhancement()
     * @uses InBoundDetails::setReferenceNumber1()
     * @uses InBoundDetails::setReferenceNumber2()
     * @uses InBoundDetails::setReferenceNumber3()
     * @uses InBoundDetails::setReferenceNumber4()
     * @uses InBoundDetails::setReferenceNumber5()
     * @uses InBoundDetails::setSpecialInstructions1()
     * @uses InBoundDetails::setSpecialInstructions2()
     * @uses InBoundDetails::setSpecialInstructions3()
     * @uses InBoundDetails::setSpecialInstructions4()
     * @param string $contractNumber
     * @param string $serviceCode
     * @param string $totalShipmentWeight
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Enhancement $enhancement
     * @param string $referenceNumber1
     * @param string $referenceNumber2
     * @param string $referenceNumber3
     * @param string $referenceNumber4
     * @param string $referenceNumber5
     * @param string $specialInstructions1
     * @param string $specialInstructions2
     * @param string $specialInstructions3
     * @param string $specialInstructions4
     */
    public function __construct($contractNumber = null, $serviceCode = null, $totalShipmentWeight = null, \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Enhancement $enhancement = null, $referenceNumber1 = null, $referenceNumber2 = null, $referenceNumber3 = null, $referenceNumber4 = null, $referenceNumber5 = null, $specialInstructions1 = null, $specialInstructions2 = null, $specialInstructions3 = null, $specialInstructions4 = null)
    {
        $this
            ->setContractNumber($contractNumber)
            ->setServiceCode($serviceCode)
            ->setTotalShipmentWeight($totalShipmentWeight)
            ->setEnhancement($enhancement)
            ->setReferenceNumber1($referenceNumber1)
            ->setReferenceNumber2($referenceNumber2)
            ->setReferenceNumber3($referenceNumber3)
            ->setReferenceNumber4($referenceNumber4)
            ->setReferenceNumber5($referenceNumber5)
            ->setSpecialInstructions1($specialInstructions1)
            ->setSpecialInstructions2($specialInstructions2)
            ->setSpecialInstructions3($specialInstructions3)
            ->setSpecialInstructions4($specialInstructions4);
    }
    /**
     * Get ContractNumber value
     * @return string
     */
    public function getContractNumber()
    {
        return $this->ContractNumber;
    }
    /**
     * Set ContractNumber value
     * @param string $contractNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractNumber, true), gettype($contractNumber)), __LINE__);
        }
        $this->ContractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get ServiceCode value
     * @return string
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * Set ServiceCode value
     * @param string $serviceCode
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Get TotalShipmentWeight value
     * @return string|null
     */
    public function getTotalShipmentWeight()
    {
        return $this->TotalShipmentWeight;
    }
    /**
     * Set TotalShipmentWeight value
     * @param string $totalShipmentWeight
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setTotalShipmentWeight($totalShipmentWeight = null)
    {
        // validation for constraint: string
        if (!is_null($totalShipmentWeight) && !is_string($totalShipmentWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalShipmentWeight, true), gettype($totalShipmentWeight)), __LINE__);
        }
        $this->TotalShipmentWeight = $totalShipmentWeight;
        return $this;
    }
    /**
     * Get Enhancement value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Enhancement|null
     */
    public function getEnhancement()
    {
        return $this->Enhancement;
    }
    /**
     * Set Enhancement value
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Enhancement $enhancement
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setEnhancement(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Enhancement $enhancement = null)
    {
        $this->Enhancement = $enhancement;
        return $this;
    }
    /**
     * Get ReferenceNumber1 value
     * @return string|null
     */
    public function getReferenceNumber1()
    {
        return $this->ReferenceNumber1;
    }
    /**
     * Set ReferenceNumber1 value
     * @param string $referenceNumber1
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setReferenceNumber1($referenceNumber1 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber1) && !is_string($referenceNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber1, true), gettype($referenceNumber1)), __LINE__);
        }
        $this->ReferenceNumber1 = $referenceNumber1;
        return $this;
    }
    /**
     * Get ReferenceNumber2 value
     * @return string|null
     */
    public function getReferenceNumber2()
    {
        return $this->ReferenceNumber2;
    }
    /**
     * Set ReferenceNumber2 value
     * @param string $referenceNumber2
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setReferenceNumber2($referenceNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber2) && !is_string($referenceNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber2, true), gettype($referenceNumber2)), __LINE__);
        }
        $this->ReferenceNumber2 = $referenceNumber2;
        return $this;
    }
    /**
     * Get ReferenceNumber3 value
     * @return string|null
     */
    public function getReferenceNumber3()
    {
        return $this->ReferenceNumber3;
    }
    /**
     * Set ReferenceNumber3 value
     * @param string $referenceNumber3
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setReferenceNumber3($referenceNumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber3) && !is_string($referenceNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber3, true), gettype($referenceNumber3)), __LINE__);
        }
        $this->ReferenceNumber3 = $referenceNumber3;
        return $this;
    }
    /**
     * Get ReferenceNumber4 value
     * @return string|null
     */
    public function getReferenceNumber4()
    {
        return $this->ReferenceNumber4;
    }
    /**
     * Set ReferenceNumber4 value
     * @param string $referenceNumber4
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setReferenceNumber4($referenceNumber4 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber4) && !is_string($referenceNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber4, true), gettype($referenceNumber4)), __LINE__);
        }
        $this->ReferenceNumber4 = $referenceNumber4;
        return $this;
    }
    /**
     * Get ReferenceNumber5 value
     * @return string|null
     */
    public function getReferenceNumber5()
    {
        return $this->ReferenceNumber5;
    }
    /**
     * Set ReferenceNumber5 value
     * @param string $referenceNumber5
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setReferenceNumber5($referenceNumber5 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber5) && !is_string($referenceNumber5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber5, true), gettype($referenceNumber5)), __LINE__);
        }
        $this->ReferenceNumber5 = $referenceNumber5;
        return $this;
    }
    /**
     * Get SpecialInstructions1 value
     * @return string|null
     */
    public function getSpecialInstructions1()
    {
        return $this->SpecialInstructions1;
    }
    /**
     * Set SpecialInstructions1 value
     * @param string $specialInstructions1
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setSpecialInstructions1($specialInstructions1 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions1) && !is_string($specialInstructions1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstructions1, true), gettype($specialInstructions1)), __LINE__);
        }
        $this->SpecialInstructions1 = $specialInstructions1;
        return $this;
    }
    /**
     * Get SpecialInstructions2 value
     * @return string|null
     */
    public function getSpecialInstructions2()
    {
        return $this->SpecialInstructions2;
    }
    /**
     * Set SpecialInstructions2 value
     * @param string $specialInstructions2
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setSpecialInstructions2($specialInstructions2 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions2) && !is_string($specialInstructions2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstructions2, true), gettype($specialInstructions2)), __LINE__);
        }
        $this->SpecialInstructions2 = $specialInstructions2;
        return $this;
    }
    /**
     * Get SpecialInstructions3 value
     * @return string|null
     */
    public function getSpecialInstructions3()
    {
        return $this->SpecialInstructions3;
    }
    /**
     * Set SpecialInstructions3 value
     * @param string $specialInstructions3
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setSpecialInstructions3($specialInstructions3 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions3) && !is_string($specialInstructions3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstructions3, true), gettype($specialInstructions3)), __LINE__);
        }
        $this->SpecialInstructions3 = $specialInstructions3;
        return $this;
    }
    /**
     * Get SpecialInstructions4 value
     * @return string|null
     */
    public function getSpecialInstructions4()
    {
        return $this->SpecialInstructions4;
    }
    /**
     * Set SpecialInstructions4 value
     * @param string $specialInstructions4
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public function setSpecialInstructions4($specialInstructions4 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions4) && !is_string($specialInstructions4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstructions4, true), gettype($specialInstructions4)), __LINE__);
        }
        $this->SpecialInstructions4 = $specialInstructions4;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\InBoundDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
