<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Departments StructType
 * @subpackage Structs
 */
class Departments extends AbstractStructBase
{
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Department[]
     */
    public $Department;
    /**
     * Constructor method for Departments
     * @uses Departments::setDepartment()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Department[] $department
     */
    public function __construct(array $department = array())
    {
        $this
            ->setDepartment($department);
    }
    /**
     * Get Department value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Department[]|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * This method is responsible for validating the values passed to the setDepartment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepartment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepartmentForArrayConstraintsFromSetDepartment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $departmentsDepartmentItem) {
            // validation for constraint: itemType
            if (!$departmentsDepartmentItem instanceof \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Department) {
                $invalidValues[] = is_object($departmentsDepartmentItem) ? get_class($departmentsDepartmentItem) : sprintf('%s(%s)', gettype($departmentsDepartmentItem), var_export($departmentsDepartmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Department property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Department, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Department value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Department[] $department
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Departments
     */
    public function setDepartment(array $department = array())
    {
        // validation for constraint: array
        if ('' !== ($departmentArrayErrorMessage = self::validateDepartmentForArrayConstraintsFromSetDepartment($department))) {
            throw new \InvalidArgumentException($departmentArrayErrorMessage, __LINE__);
        }
        $this->Department = $department;
        return $this;
    }
    /**
     * Add item to Department value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Department $item
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Departments
     */
    public function addToDepartment(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Department $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Department) {
            throw new \InvalidArgumentException(sprintf('The Department property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Department, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Department[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Departments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
