<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact StructType
 * @subpackage Structs
 */
class Contact extends AbstractStructBase
{
    /**
     * The BusinessName
     * @var string
     */
    public $BusinessName;
    /**
     * The ContactName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The Fax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The MobilePhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MobilePhone;
    /**
     * The SendersName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SendersName;
    /**
     * The Notifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Notifications
     */
    public $Notifications;
    /**
     * Constructor method for Contact
     * @uses Contact::setBusinessName()
     * @uses Contact::setContactName()
     * @uses Contact::setEmailAddress()
     * @uses Contact::setTelephone()
     * @uses Contact::setFax()
     * @uses Contact::setMobilePhone()
     * @uses Contact::setSendersName()
     * @uses Contact::setNotifications()
     * @param string $businessName
     * @param string $contactName
     * @param string $emailAddress
     * @param string $telephone
     * @param string $fax
     * @param string $mobilePhone
     * @param string $sendersName
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Notifications $notifications
     */
    public function __construct($businessName = null, $contactName = null, $emailAddress = null, $telephone = null, $fax = null, $mobilePhone = null, $sendersName = null, \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Notifications $notifications = null)
    {
        $this
            ->setBusinessName($businessName)
            ->setContactName($contactName)
            ->setEmailAddress($emailAddress)
            ->setTelephone($telephone)
            ->setFax($fax)
            ->setMobilePhone($mobilePhone)
            ->setSendersName($sendersName)
            ->setNotifications($notifications);
    }
    /**
     * Get BusinessName value
     * @return string|null
     */
    public function getBusinessName()
    {
        return $this->BusinessName;
    }
    /**
     * Set BusinessName value
     * @param string $businessName
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Contact
     */
    public function setBusinessName($businessName = null)
    {
        // validation for constraint: string
        if (!is_null($businessName) && !is_string($businessName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessName, true), gettype($businessName)), __LINE__);
        }
        $this->BusinessName = $businessName;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Contact
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Contact
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Contact
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Contact
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get MobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }
    /**
     * Set MobilePhone value
     * @param string $mobilePhone
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Contact
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        $this->MobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get SendersName value
     * @return string|null
     */
    public function getSendersName()
    {
        return $this->SendersName;
    }
    /**
     * Set SendersName value
     * @param string $sendersName
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Contact
     */
    public function setSendersName($sendersName = null)
    {
        // validation for constraint: string
        if (!is_null($sendersName) && !is_string($sendersName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendersName, true), gettype($sendersName)), __LINE__);
        }
        $this->SendersName = $sendersName;
        return $this;
    }
    /**
     * Get Notifications value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Notifications|null
     */
    public function getNotifications()
    {
        return $this->Notifications;
    }
    /**
     * Set Notifications value
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Notifications $notifications
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Contact
     */
    public function setNotifications(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Notifications $notifications = null)
    {
        $this->Notifications = $notifications;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Contact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
