<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompletedShipmentInfoCreatePrint StructType
 * @subpackage Structs
 */
class CompletedShipmentInfoCreatePrint extends AbstractStructBase
{
    /**
     * The LeadShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LeadShipmentNumber;
    /**
     * The ShipmentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The DeliveryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The CompletedShipments
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipments
     */
    public $CompletedShipments;
    /**
     * Constructor method for CompletedShipmentInfoCreatePrint
     * @uses CompletedShipmentInfoCreatePrint::setLeadShipmentNumber()
     * @uses CompletedShipmentInfoCreatePrint::setShipmentNumber()
     * @uses CompletedShipmentInfoCreatePrint::setDeliveryDate()
     * @uses CompletedShipmentInfoCreatePrint::setStatus()
     * @uses CompletedShipmentInfoCreatePrint::setCompletedShipments()
     * @param string $leadShipmentNumber
     * @param string $shipmentNumber
     * @param string $deliveryDate
     * @param string $status
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipments $completedShipments
     */
    public function __construct($leadShipmentNumber = null, $shipmentNumber = null, $deliveryDate = null, $status = null, \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipments $completedShipments = null)
    {
        $this
            ->setLeadShipmentNumber($leadShipmentNumber)
            ->setShipmentNumber($shipmentNumber)
            ->setDeliveryDate($deliveryDate)
            ->setStatus($status)
            ->setCompletedShipments($completedShipments);
    }
    /**
     * Get LeadShipmentNumber value
     * @return string|null
     */
    public function getLeadShipmentNumber()
    {
        return $this->LeadShipmentNumber;
    }
    /**
     * Set LeadShipmentNumber value
     * @param string $leadShipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipmentInfoCreatePrint
     */
    public function setLeadShipmentNumber($leadShipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($leadShipmentNumber) && !is_string($leadShipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadShipmentNumber, true), gettype($leadShipmentNumber)), __LINE__);
        }
        $this->LeadShipmentNumber = $leadShipmentNumber;
        return $this;
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipmentInfoCreatePrint
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipmentInfoCreatePrint
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipmentInfoCreatePrint
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CompletedShipments value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipments|null
     */
    public function getCompletedShipments()
    {
        return $this->CompletedShipments;
    }
    /**
     * Set CompletedShipments value
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipments $completedShipments
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipmentInfoCreatePrint
     */
    public function setCompletedShipments(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipments $completedShipments = null)
    {
        $this->CompletedShipments = $completedShipments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedShipmentInfoCreatePrint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
