<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompletedReturnInfo StructType
 * @subpackage Structs
 */
class CompletedReturnInfo extends AbstractStructBase
{
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The ShipmentNumber
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The CollectionTime
     * @var \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\DateTimeRange
     */
    public $CollectionTime;
    /**
     * Constructor method for CompletedReturnInfo
     * @uses CompletedReturnInfo::setStatus()
     * @uses CompletedReturnInfo::setShipmentNumber()
     * @uses CompletedReturnInfo::setCollectionTime()
     * @param string $status
     * @param string $shipmentNumber
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\DateTimeRange $collectionTime
     */
    public function __construct($status = null, $shipmentNumber = null, \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\DateTimeRange $collectionTime = null)
    {
        $this
            ->setStatus($status)
            ->setShipmentNumber($shipmentNumber)
            ->setCollectionTime($collectionTime);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedReturnInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedReturnInfo
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get CollectionTime value
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\DateTimeRange|null
     */
    public function getCollectionTime()
    {
        return $this->CollectionTime;
    }
    /**
     * Set CollectionTime value
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\DateTimeRange $collectionTime
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedReturnInfo
     */
    public function setCollectionTime(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\DateTimeRange $collectionTime = null)
    {
        $this->CollectionTime = $collectionTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CompletedReturnInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
