<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelShipmentRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ns:CancelShipmentRequest
 * @subpackage Structs
 */
class CancelShipmentRequest extends BaseRequest
{
    /**
     * The ShipmentNumber
     * @var string
     */
    public $ShipmentNumber;
    /**
     * Constructor method for CancelShipmentRequest
     * @uses CancelShipmentRequest::setShipmentNumber()
     * @param string $shipmentNumber
     */
    public function __construct($shipmentNumber = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber);
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CancelShipmentRequest
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\CancelShipmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
