<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The AddressLine1
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $AddressLine1;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Country;
    /**
     * The AddressLine2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine2;
    /**
     * The AddressLine3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressLine3;
    /**
     * The Town
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Town;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Postcode;
    /**
     * Constructor method for Address
     * @uses Address::setAddressLine1()
     * @uses Address::setCountry()
     * @uses Address::setAddressLine2()
     * @uses Address::setAddressLine3()
     * @uses Address::setTown()
     * @uses Address::setPostcode()
     * @param string $addressLine1
     * @param string $country
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $town
     * @param string $postcode
     */
    public function __construct($addressLine1 = null, $country = null, $addressLine2 = null, $addressLine3 = null, $town = null, $postcode = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setCountry($country)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setTown($town)
            ->setPostcode($postcode);
    }
    /**
     * Get AddressLine1 value
     * @return string
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Address
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get Country value
     * @return string
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Address
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Address
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get AddressLine3 value
     * @return string|null
     */
    public function getAddressLine3()
    {
        return $this->AddressLine3;
    }
    /**
     * Set AddressLine3 value
     * @param string $addressLine3
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Address
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine3, true), gettype($addressLine3)), __LINE__);
        }
        $this->AddressLine3 = $addressLine3;
        return $this;
    }
    /**
     * Get Town value
     * @return string|null
     */
    public function getTown()
    {
        return $this->Town;
    }
    /**
     * Set Town value
     * @param string $town
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Address
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($town, true), gettype($town)), __LINE__);
        }
        $this->Town = $town;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Address
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
