<?php

namespace app\Service\ShipmentHandler\ParcelForce\ExpressLink\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Print ServiceType
 * @subpackage Services
 */
class _Print extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named printLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintLabelRequest $printLabelRequest
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintLabelReply|bool
     */
    public function printLabel(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintLabelRequest $printLabelRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->printLabel($printLabelRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named printDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintDocumentRequest $printDocumentRequest
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintDocumentReply|bool
     */
    public function printDocument(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintDocumentRequest $printDocumentRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->printDocument($printDocumentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named printManifest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintManifestRequest $printManifestRequest
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintManifestReply|bool
     */
    public function printManifest(\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintManifestRequest $printManifestRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->printManifest($printManifestRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintDocumentReply|\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintLabelReply|\app\Service\ShipmentHandler\ParcelForce\ExpressLink\StructType\PrintManifestReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
