<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecifiedPostOffice StructType
 * @subpackage Structs
 */
class SpecifiedPostOffice extends AbstractStructBase
{
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Postcode;
    /**
     * The PostOffice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice[]
     */
    public $PostOffice;
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The PostOfficeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostOfficeID;
    /**
     * Constructor method for SpecifiedPostOffice
     * @uses SpecifiedPostOffice::setPostcode()
     * @uses SpecifiedPostOffice::setPostOffice()
     * @uses SpecifiedPostOffice::setCount()
     * @uses SpecifiedPostOffice::setPostOfficeID()
     * @param string $postcode
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice[] $postOffice
     * @param int $count
     * @param string $postOfficeID
     */
    public function __construct($postcode = null, array $postOffice = array(), $count = null, $postOfficeID = null)
    {
        $this
            ->setPostcode($postcode)
            ->setPostOffice($postOffice)
            ->setCount($count)
            ->setPostOfficeID($postOfficeID);
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get PostOffice value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice[]|null
     */
    public function getPostOffice()
    {
        return $this->PostOffice;
    }
    /**
     * This method is responsible for validating the values passed to the setPostOffice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPostOffice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePostOfficeForArrayConstraintsFromSetPostOffice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specifiedPostOfficePostOfficeItem) {
            // validation for constraint: itemType
            if (!$specifiedPostOfficePostOfficeItem instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice) {
                $invalidValues[] = is_object($specifiedPostOfficePostOfficeItem) ? get_class($specifiedPostOfficePostOfficeItem) : sprintf('%s(%s)', gettype($specifiedPostOfficePostOfficeItem), var_export($specifiedPostOfficePostOfficeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PostOffice property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PostOffice value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice[] $postOffice
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice
     */
    public function setPostOffice(array $postOffice = array())
    {
        // validation for constraint: array
        if ('' !== ($postOfficeArrayErrorMessage = self::validatePostOfficeForArrayConstraintsFromSetPostOffice($postOffice))) {
            throw new \InvalidArgumentException($postOfficeArrayErrorMessage, __LINE__);
        }
        $this->PostOffice = $postOffice;
        return $this;
    }
    /**
     * Add item to PostOffice value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice $item
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice
     */
    public function addToPostOffice(\app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice) {
            throw new \InvalidArgumentException(sprintf('The PostOffice property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PostOffice[] = $item;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get PostOfficeID value
     * @return string|null
     */
    public function getPostOfficeID()
    {
        return $this->PostOfficeID;
    }
    /**
     * Set PostOfficeID value
     * @param string $postOfficeID
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice
     */
    public function setPostOfficeID($postOfficeID = null)
    {
        // validation for constraint: string
        if (!is_null($postOfficeID) && !is_string($postOfficeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postOfficeID, true), gettype($postOfficeID)), __LINE__);
        }
        $this->PostOfficeID = $postOfficeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
