<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceCodes StructType
 * @subpackage Structs
 */
class ServiceCodes extends AbstractStructBase
{
    /**
     * The ServiceCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ServiceCode;
    /**
     * Constructor method for ServiceCodes
     * @uses ServiceCodes::setServiceCode()
     * @param string[] $serviceCode
     */
    public function __construct(array $serviceCode = array())
    {
        $this
            ->setServiceCode($serviceCode);
    }
    /**
     * Get ServiceCode value
     * @return string[]|null
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceCodeForArrayConstraintsFromSetServiceCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceCodesServiceCodeItem) {
            // validation for constraint: itemType
            if (!is_string($serviceCodesServiceCodeItem)) {
                $invalidValues[] = is_object($serviceCodesServiceCodeItem) ? get_class($serviceCodesServiceCodeItem) : sprintf('%s(%s)', gettype($serviceCodesServiceCodeItem), var_export($serviceCodesServiceCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceCode value
     * @throws \InvalidArgumentException
     * @param string[] $serviceCode
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes
     */
    public function setServiceCode(array $serviceCode = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceCodeArrayErrorMessage = self::validateServiceCodeForArrayConstraintsFromSetServiceCode($serviceCode))) {
            throw new \InvalidArgumentException($serviceCodeArrayErrorMessage, __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Add item to ServiceCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes
     */
    public function addToServiceCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ServiceCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
