<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Returns StructType
 * @subpackage Structs
 */
class Returns extends AbstractStructBase
{
    /**
     * The EmailLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var bool
     */
    public $EmailLabel;
    /**
     * The ReturnsEmail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReturnsEmail;
    /**
     * The EmailMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EmailMessage;
    /**
     * Constructor method for Returns
     * @uses Returns::setEmailLabel()
     * @uses Returns::setReturnsEmail()
     * @uses Returns::setEmailMessage()
     * @param bool $emailLabel
     * @param string $returnsEmail
     * @param string $emailMessage
     */
    public function __construct($emailLabel = null, $returnsEmail = null, $emailMessage = null)
    {
        $this
            ->setEmailLabel($emailLabel)
            ->setReturnsEmail($returnsEmail)
            ->setEmailMessage($emailMessage);
    }
    /**
     * Get EmailLabel value
     * @return bool
     */
    public function getEmailLabel()
    {
        return $this->EmailLabel;
    }
    /**
     * Set EmailLabel value
     * @param bool $emailLabel
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Returns
     */
    public function setEmailLabel($emailLabel = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailLabel) && !is_bool($emailLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailLabel, true), gettype($emailLabel)), __LINE__);
        }
        $this->EmailLabel = $emailLabel;
        return $this;
    }
    /**
     * Get ReturnsEmail value
     * @return string|null
     */
    public function getReturnsEmail()
    {
        return $this->ReturnsEmail;
    }
    /**
     * Set ReturnsEmail value
     * @param string $returnsEmail
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Returns
     */
    public function setReturnsEmail($returnsEmail = null)
    {
        // validation for constraint: string
        if (!is_null($returnsEmail) && !is_string($returnsEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnsEmail, true), gettype($returnsEmail)), __LINE__);
        }
        $this->ReturnsEmail = $returnsEmail;
        return $this;
    }
    /**
     * Get EmailMessage value
     * @return string|null
     */
    public function getEmailMessage()
    {
        return $this->EmailMessage;
    }
    /**
     * Set EmailMessage value
     * @param string $emailMessage
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Returns
     */
    public function setEmailMessage($emailMessage = null)
    {
        // validation for constraint: string
        if (!is_null($emailMessage) && !is_string($emailMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailMessage, true), gettype($emailMessage)), __LINE__);
        }
        $this->EmailMessage = $emailMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Returns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
