<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestedShipment StructType
 * @subpackage Structs
 */
class RequestedShipment extends AbstractStructBase
{
    /**
     * The DepartmentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DepartmentId;
    /**
     * The ShipmentType
     * @var string
     */
    public $ShipmentType;
    /**
     * The ContractNumber
     * @var string
     */
    public $ContractNumber;
    /**
     * The RequestId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RequestId;
    /**
     * The ServiceCode
     * @var string
     */
    public $ServiceCode;
    /**
     * The PrePrinted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PrePrinted;
    /**
     * The ShippingDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingDate;
    /**
     * The JobReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $JobReference;
    /**
     * The RecipientContact
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Contact
     */
    public $RecipientContact;
    /**
     * The RecipientAddress
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Address
     */
    public $RecipientAddress;
    /**
     * The ImporterContact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Contact
     */
    public $ImporterContact;
    /**
     * The ImporterAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Address
     */
    public $ImporterAddress;
    /**
     * The ExporterContact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Contact
     */
    public $ExporterContact;
    /**
     * The ExporterAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Address
     */
    public $ExporterAddress;
    /**
     * The SenderContact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Contact
     */
    public $SenderContact;
    /**
     * The SenderAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Address
     */
    public $SenderAddress;
    /**
     * The TotalNumberOfParcels
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalNumberOfParcels;
    /**
     * The TotalShipmentWeight
     * Meta informations extracted from the WSDL
     * - base: xs:decimal
     * - minOccurs: 0
     * @var float
     */
    public $TotalShipmentWeight;
    /**
     * The Enhancement
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Enhancement
     */
    public $Enhancement;
    /**
     * The DeliveryOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public $DeliveryOptions;
    /**
     * The HazardousGoods
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGoods
     */
    public $HazardousGoods;
    /**
     * The Returns
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Returns
     */
    public $Returns;
    /**
     * The DropOffInd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DropOffInd;
    /**
     * The PrintOwnLabel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PrintOwnLabel;
    /**
     * The CollectionInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\CollectionInfo
     */
    public $CollectionInfo;
    /**
     * The InternationalInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\InternationalInfo
     */
    public $InternationalInfo;
    /**
     * The ReferenceNumber1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber1;
    /**
     * The ReferenceNumber2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber2;
    /**
     * The ReferenceNumber3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber3;
    /**
     * The ReferenceNumber4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber4;
    /**
     * The ReferenceNumber5
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber5;
    /**
     * The SpecialInstructions1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstructions1;
    /**
     * The SpecialInstructions2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstructions2;
    /**
     * The SpecialInstructions3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstructions3;
    /**
     * The SpecialInstructions4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstructions4;
    /**
     * The InBoundContact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Contact
     */
    public $InBoundContact;
    /**
     * The InBoundAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Address
     */
    public $InBoundAddress;
    /**
     * The InBoundDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\InBoundDetails
     */
    public $InBoundDetails;
    /**
     * The ExchangeInstructions1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeInstructions1;
    /**
     * The ExchangeInstructions2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeInstructions2;
    /**
     * The ExchangeInstructions3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExchangeInstructions3;
    /**
     * The ConsignmentHandling
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ConsignmentHandling;
    /**
     * Constructor method for RequestedShipment
     * @uses RequestedShipment::setDepartmentId()
     * @uses RequestedShipment::setShipmentType()
     * @uses RequestedShipment::setContractNumber()
     * @uses RequestedShipment::setRequestId()
     * @uses RequestedShipment::setServiceCode()
     * @uses RequestedShipment::setPrePrinted()
     * @uses RequestedShipment::setShippingDate()
     * @uses RequestedShipment::setJobReference()
     * @uses RequestedShipment::setRecipientContact()
     * @uses RequestedShipment::setRecipientAddress()
     * @uses RequestedShipment::setImporterContact()
     * @uses RequestedShipment::setImporterAddress()
     * @uses RequestedShipment::setExporterContact()
     * @uses RequestedShipment::setExporterAddress()
     * @uses RequestedShipment::setSenderContact()
     * @uses RequestedShipment::setSenderAddress()
     * @uses RequestedShipment::setTotalNumberOfParcels()
     * @uses RequestedShipment::setTotalShipmentWeight()
     * @uses RequestedShipment::setEnhancement()
     * @uses RequestedShipment::setDeliveryOptions()
     * @uses RequestedShipment::setHazardousGoods()
     * @uses RequestedShipment::setReturns()
     * @uses RequestedShipment::setDropOffInd()
     * @uses RequestedShipment::setPrintOwnLabel()
     * @uses RequestedShipment::setCollectionInfo()
     * @uses RequestedShipment::setInternationalInfo()
     * @uses RequestedShipment::setReferenceNumber1()
     * @uses RequestedShipment::setReferenceNumber2()
     * @uses RequestedShipment::setReferenceNumber3()
     * @uses RequestedShipment::setReferenceNumber4()
     * @uses RequestedShipment::setReferenceNumber5()
     * @uses RequestedShipment::setSpecialInstructions1()
     * @uses RequestedShipment::setSpecialInstructions2()
     * @uses RequestedShipment::setSpecialInstructions3()
     * @uses RequestedShipment::setSpecialInstructions4()
     * @uses RequestedShipment::setInBoundContact()
     * @uses RequestedShipment::setInBoundAddress()
     * @uses RequestedShipment::setInBoundDetails()
     * @uses RequestedShipment::setExchangeInstructions1()
     * @uses RequestedShipment::setExchangeInstructions2()
     * @uses RequestedShipment::setExchangeInstructions3()
     * @uses RequestedShipment::setConsignmentHandling()
     * @param int $departmentId
     * @param string $shipmentType
     * @param string $contractNumber
     * @param int $requestId
     * @param string $serviceCode
     * @param bool $prePrinted
     * @param string $shippingDate
     * @param string $jobReference
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $recipientContact
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $recipientAddress
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $importerContact
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $importerAddress
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $exporterContact
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $exporterAddress
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $senderContact
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $senderAddress
     * @param int $totalNumberOfParcels
     * @param float $totalShipmentWeight
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Enhancement $enhancement
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions $deliveryOptions
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGoods $hazardousGoods
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Returns $returns
     * @param string $dropOffInd
     * @param bool $printOwnLabel
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\CollectionInfo $collectionInfo
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\InternationalInfo $internationalInfo
     * @param string $referenceNumber1
     * @param string $referenceNumber2
     * @param string $referenceNumber3
     * @param string $referenceNumber4
     * @param string $referenceNumber5
     * @param string $specialInstructions1
     * @param string $specialInstructions2
     * @param string $specialInstructions3
     * @param string $specialInstructions4
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $inBoundContact
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $inBoundAddress
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\InBoundDetails $inBoundDetails
     * @param string $exchangeInstructions1
     * @param string $exchangeInstructions2
     * @param string $exchangeInstructions3
     * @param bool $consignmentHandling
     */
    public function __construct($departmentId = null, $shipmentType = null, $contractNumber = null, $requestId = null, $serviceCode = null, $prePrinted = null, $shippingDate = null, $jobReference = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $recipientContact = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Address $recipientAddress = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $importerContact = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Address $importerAddress = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $exporterContact = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Address $exporterAddress = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $senderContact = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Address $senderAddress = null, $totalNumberOfParcels = null, $totalShipmentWeight = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Enhancement $enhancement = null, \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions $deliveryOptions = null, \app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGoods $hazardousGoods = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Returns $returns = null, $dropOffInd = null, $printOwnLabel = null, \app\Service\ShipmentHandler\ParcelForce\StructType\CollectionInfo $collectionInfo = null, \app\Service\ShipmentHandler\ParcelForce\StructType\InternationalInfo $internationalInfo = null, $referenceNumber1 = null, $referenceNumber2 = null, $referenceNumber3 = null, $referenceNumber4 = null, $referenceNumber5 = null, $specialInstructions1 = null, $specialInstructions2 = null, $specialInstructions3 = null, $specialInstructions4 = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $inBoundContact = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Address $inBoundAddress = null, \app\Service\ShipmentHandler\ParcelForce\StructType\InBoundDetails $inBoundDetails = null, $exchangeInstructions1 = null, $exchangeInstructions2 = null, $exchangeInstructions3 = null, $consignmentHandling = null)
    {
        $this
            ->setDepartmentId($departmentId)
            ->setShipmentType($shipmentType)
            ->setContractNumber($contractNumber)
            ->setRequestId($requestId)
            ->setServiceCode($serviceCode)
            ->setPrePrinted($prePrinted)
            ->setShippingDate($shippingDate)
            ->setJobReference($jobReference)
            ->setRecipientContact($recipientContact)
            ->setRecipientAddress($recipientAddress)
            ->setImporterContact($importerContact)
            ->setImporterAddress($importerAddress)
            ->setExporterContact($exporterContact)
            ->setExporterAddress($exporterAddress)
            ->setSenderContact($senderContact)
            ->setSenderAddress($senderAddress)
            ->setTotalNumberOfParcels($totalNumberOfParcels)
            ->setTotalShipmentWeight($totalShipmentWeight)
            ->setEnhancement($enhancement)
            ->setDeliveryOptions($deliveryOptions)
            ->setHazardousGoods($hazardousGoods)
            ->setReturns($returns)
            ->setDropOffInd($dropOffInd)
            ->setPrintOwnLabel($printOwnLabel)
            ->setCollectionInfo($collectionInfo)
            ->setInternationalInfo($internationalInfo)
            ->setReferenceNumber1($referenceNumber1)
            ->setReferenceNumber2($referenceNumber2)
            ->setReferenceNumber3($referenceNumber3)
            ->setReferenceNumber4($referenceNumber4)
            ->setReferenceNumber5($referenceNumber5)
            ->setSpecialInstructions1($specialInstructions1)
            ->setSpecialInstructions2($specialInstructions2)
            ->setSpecialInstructions3($specialInstructions3)
            ->setSpecialInstructions4($specialInstructions4)
            ->setInBoundContact($inBoundContact)
            ->setInBoundAddress($inBoundAddress)
            ->setInBoundDetails($inBoundDetails)
            ->setExchangeInstructions1($exchangeInstructions1)
            ->setExchangeInstructions2($exchangeInstructions2)
            ->setExchangeInstructions3($exchangeInstructions3)
            ->setConsignmentHandling($consignmentHandling);
    }
    /**
     * Get DepartmentId value
     * @return int|null
     */
    public function getDepartmentId()
    {
        return $this->DepartmentId;
    }
    /**
     * Set DepartmentId value
     * @param int $departmentId
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setDepartmentId($departmentId = null)
    {
        // validation for constraint: int
        if (!is_null($departmentId) && !(is_int($departmentId) || ctype_digit($departmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($departmentId, true), gettype($departmentId)), __LINE__);
        }
        $this->DepartmentId = $departmentId;
        return $this;
    }
    /**
     * Get ShipmentType value
     * @return string|null
     */
    public function getShipmentType()
    {
        return $this->ShipmentType;
    }
    /**
     * Set ShipmentType value
     * @param string $shipmentType
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setShipmentType($shipmentType = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentType) && !is_string($shipmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentType, true), gettype($shipmentType)), __LINE__);
        }
        $this->ShipmentType = $shipmentType;
        return $this;
    }
    /**
     * Get ContractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->ContractNumber;
    }
    /**
     * Set ContractNumber value
     * @param string $contractNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractNumber, true), gettype($contractNumber)), __LINE__);
        }
        $this->ContractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get RequestId value
     * @return int|null
     */
    public function getRequestId()
    {
        return $this->RequestId;
    }
    /**
     * Set RequestId value
     * @param int $requestId
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: int
        if (!is_null($requestId) && !(is_int($requestId) || ctype_digit($requestId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        $this->RequestId = $requestId;
        return $this;
    }
    /**
     * Get ServiceCode value
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * Set ServiceCode value
     * @param string $serviceCode
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Get PrePrinted value
     * @return bool|null
     */
    public function getPrePrinted()
    {
        return $this->PrePrinted;
    }
    /**
     * Set PrePrinted value
     * @param bool $prePrinted
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setPrePrinted($prePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($prePrinted) && !is_bool($prePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prePrinted, true), gettype($prePrinted)), __LINE__);
        }
        $this->PrePrinted = $prePrinted;
        return $this;
    }
    /**
     * Get ShippingDate value
     * @return string|null
     */
    public function getShippingDate()
    {
        return $this->ShippingDate;
    }
    /**
     * Set ShippingDate value
     * @param string $shippingDate
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setShippingDate($shippingDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDate) && !is_string($shippingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingDate, true), gettype($shippingDate)), __LINE__);
        }
        $this->ShippingDate = $shippingDate;
        return $this;
    }
    /**
     * Get JobReference value
     * @return string|null
     */
    public function getJobReference()
    {
        return $this->JobReference;
    }
    /**
     * Set JobReference value
     * @param string $jobReference
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setJobReference($jobReference = null)
    {
        // validation for constraint: string
        if (!is_null($jobReference) && !is_string($jobReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobReference, true), gettype($jobReference)), __LINE__);
        }
        $this->JobReference = $jobReference;
        return $this;
    }
    /**
     * Get RecipientContact value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Contact|null
     */
    public function getRecipientContact()
    {
        return $this->RecipientContact;
    }
    /**
     * Set RecipientContact value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $recipientContact
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setRecipientContact(\app\Service\ShipmentHandler\ParcelForce\StructType\Contact $recipientContact = null)
    {
        $this->RecipientContact = $recipientContact;
        return $this;
    }
    /**
     * Get RecipientAddress value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Address|null
     */
    public function getRecipientAddress()
    {
        return $this->RecipientAddress;
    }
    /**
     * Set RecipientAddress value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $recipientAddress
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setRecipientAddress(\app\Service\ShipmentHandler\ParcelForce\StructType\Address $recipientAddress = null)
    {
        $this->RecipientAddress = $recipientAddress;
        return $this;
    }
    /**
     * Get ImporterContact value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Contact|null
     */
    public function getImporterContact()
    {
        return $this->ImporterContact;
    }
    /**
     * Set ImporterContact value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $importerContact
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setImporterContact(\app\Service\ShipmentHandler\ParcelForce\StructType\Contact $importerContact = null)
    {
        $this->ImporterContact = $importerContact;
        return $this;
    }
    /**
     * Get ImporterAddress value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Address|null
     */
    public function getImporterAddress()
    {
        return $this->ImporterAddress;
    }
    /**
     * Set ImporterAddress value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $importerAddress
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setImporterAddress(\app\Service\ShipmentHandler\ParcelForce\StructType\Address $importerAddress = null)
    {
        $this->ImporterAddress = $importerAddress;
        return $this;
    }
    /**
     * Get ExporterContact value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Contact|null
     */
    public function getExporterContact()
    {
        return $this->ExporterContact;
    }
    /**
     * Set ExporterContact value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $exporterContact
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setExporterContact(\app\Service\ShipmentHandler\ParcelForce\StructType\Contact $exporterContact = null)
    {
        $this->ExporterContact = $exporterContact;
        return $this;
    }
    /**
     * Get ExporterAddress value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Address|null
     */
    public function getExporterAddress()
    {
        return $this->ExporterAddress;
    }
    /**
     * Set ExporterAddress value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $exporterAddress
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setExporterAddress(\app\Service\ShipmentHandler\ParcelForce\StructType\Address $exporterAddress = null)
    {
        $this->ExporterAddress = $exporterAddress;
        return $this;
    }
    /**
     * Get SenderContact value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Contact|null
     */
    public function getSenderContact()
    {
        return $this->SenderContact;
    }
    /**
     * Set SenderContact value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $senderContact
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setSenderContact(\app\Service\ShipmentHandler\ParcelForce\StructType\Contact $senderContact = null)
    {
        $this->SenderContact = $senderContact;
        return $this;
    }
    /**
     * Get SenderAddress value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Address|null
     */
    public function getSenderAddress()
    {
        return $this->SenderAddress;
    }
    /**
     * Set SenderAddress value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $senderAddress
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setSenderAddress(\app\Service\ShipmentHandler\ParcelForce\StructType\Address $senderAddress = null)
    {
        $this->SenderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get TotalNumberOfParcels value
     * @return int|null
     */
    public function getTotalNumberOfParcels()
    {
        return $this->TotalNumberOfParcels;
    }
    /**
     * Set TotalNumberOfParcels value
     * @param int $totalNumberOfParcels
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setTotalNumberOfParcels($totalNumberOfParcels = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfParcels) && !(is_int($totalNumberOfParcels) || ctype_digit($totalNumberOfParcels))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumberOfParcels, true), gettype($totalNumberOfParcels)), __LINE__);
        }
        $this->TotalNumberOfParcels = $totalNumberOfParcels;
        return $this;
    }
    /**
     * Get TotalShipmentWeight value
     * @return float|null
     */
    public function getTotalShipmentWeight()
    {
        return $this->TotalShipmentWeight;
    }
    /**
     * Set TotalShipmentWeight value
     * @param float $totalShipmentWeight
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setTotalShipmentWeight($totalShipmentWeight = null)
    {
        // validation for constraint: float
        if (!is_null($totalShipmentWeight) && !(is_float($totalShipmentWeight) || is_numeric($totalShipmentWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalShipmentWeight, true), gettype($totalShipmentWeight)), __LINE__);
        }
        $this->TotalShipmentWeight = $totalShipmentWeight;
        return $this;
    }
    /**
     * Get Enhancement value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Enhancement|null
     */
    public function getEnhancement()
    {
        return $this->Enhancement;
    }
    /**
     * Set Enhancement value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Enhancement $enhancement
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setEnhancement(\app\Service\ShipmentHandler\ParcelForce\StructType\Enhancement $enhancement = null)
    {
        $this->Enhancement = $enhancement;
        return $this;
    }
    /**
     * Get DeliveryOptions value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions|null
     */
    public function getDeliveryOptions()
    {
        return $this->DeliveryOptions;
    }
    /**
     * Set DeliveryOptions value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions $deliveryOptions
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setDeliveryOptions(\app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions $deliveryOptions = null)
    {
        $this->DeliveryOptions = $deliveryOptions;
        return $this;
    }
    /**
     * Get HazardousGoods value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGoods|null
     */
    public function getHazardousGoods()
    {
        return $this->HazardousGoods;
    }
    /**
     * Set HazardousGoods value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGoods $hazardousGoods
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setHazardousGoods(\app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGoods $hazardousGoods = null)
    {
        $this->HazardousGoods = $hazardousGoods;
        return $this;
    }
    /**
     * Get Returns value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Returns|null
     */
    public function getReturns()
    {
        return $this->Returns;
    }
    /**
     * Set Returns value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Returns $returns
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setReturns(\app\Service\ShipmentHandler\ParcelForce\StructType\Returns $returns = null)
    {
        $this->Returns = $returns;
        return $this;
    }
    /**
     * Get DropOffInd value
     * @return string|null
     */
    public function getDropOffInd()
    {
        return $this->DropOffInd;
    }
    /**
     * Set DropOffInd value
     * @param string $dropOffInd
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setDropOffInd($dropOffInd = null)
    {
        // validation for constraint: string
        if (!is_null($dropOffInd) && !is_string($dropOffInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dropOffInd, true), gettype($dropOffInd)), __LINE__);
        }
        $this->DropOffInd = $dropOffInd;
        return $this;
    }
    /**
     * Get PrintOwnLabel value
     * @return bool|null
     */
    public function getPrintOwnLabel()
    {
        return $this->PrintOwnLabel;
    }
    /**
     * Set PrintOwnLabel value
     * @param bool $printOwnLabel
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setPrintOwnLabel($printOwnLabel = null)
    {
        // validation for constraint: boolean
        if (!is_null($printOwnLabel) && !is_bool($printOwnLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printOwnLabel, true), gettype($printOwnLabel)), __LINE__);
        }
        $this->PrintOwnLabel = $printOwnLabel;
        return $this;
    }
    /**
     * Get CollectionInfo value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CollectionInfo|null
     */
    public function getCollectionInfo()
    {
        return $this->CollectionInfo;
    }
    /**
     * Set CollectionInfo value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\CollectionInfo $collectionInfo
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setCollectionInfo(\app\Service\ShipmentHandler\ParcelForce\StructType\CollectionInfo $collectionInfo = null)
    {
        $this->CollectionInfo = $collectionInfo;
        return $this;
    }
    /**
     * Get InternationalInfo value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\InternationalInfo|null
     */
    public function getInternationalInfo()
    {
        return $this->InternationalInfo;
    }
    /**
     * Set InternationalInfo value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\InternationalInfo $internationalInfo
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setInternationalInfo(\app\Service\ShipmentHandler\ParcelForce\StructType\InternationalInfo $internationalInfo = null)
    {
        $this->InternationalInfo = $internationalInfo;
        return $this;
    }
    /**
     * Get ReferenceNumber1 value
     * @return string|null
     */
    public function getReferenceNumber1()
    {
        return $this->ReferenceNumber1;
    }
    /**
     * Set ReferenceNumber1 value
     * @param string $referenceNumber1
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setReferenceNumber1($referenceNumber1 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber1) && !is_string($referenceNumber1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber1, true), gettype($referenceNumber1)), __LINE__);
        }
        $this->ReferenceNumber1 = $referenceNumber1;
        return $this;
    }
    /**
     * Get ReferenceNumber2 value
     * @return string|null
     */
    public function getReferenceNumber2()
    {
        return $this->ReferenceNumber2;
    }
    /**
     * Set ReferenceNumber2 value
     * @param string $referenceNumber2
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setReferenceNumber2($referenceNumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber2) && !is_string($referenceNumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber2, true), gettype($referenceNumber2)), __LINE__);
        }
        $this->ReferenceNumber2 = $referenceNumber2;
        return $this;
    }
    /**
     * Get ReferenceNumber3 value
     * @return string|null
     */
    public function getReferenceNumber3()
    {
        return $this->ReferenceNumber3;
    }
    /**
     * Set ReferenceNumber3 value
     * @param string $referenceNumber3
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setReferenceNumber3($referenceNumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber3) && !is_string($referenceNumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber3, true), gettype($referenceNumber3)), __LINE__);
        }
        $this->ReferenceNumber3 = $referenceNumber3;
        return $this;
    }
    /**
     * Get ReferenceNumber4 value
     * @return string|null
     */
    public function getReferenceNumber4()
    {
        return $this->ReferenceNumber4;
    }
    /**
     * Set ReferenceNumber4 value
     * @param string $referenceNumber4
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setReferenceNumber4($referenceNumber4 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber4) && !is_string($referenceNumber4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber4, true), gettype($referenceNumber4)), __LINE__);
        }
        $this->ReferenceNumber4 = $referenceNumber4;
        return $this;
    }
    /**
     * Get ReferenceNumber5 value
     * @return string|null
     */
    public function getReferenceNumber5()
    {
        return $this->ReferenceNumber5;
    }
    /**
     * Set ReferenceNumber5 value
     * @param string $referenceNumber5
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setReferenceNumber5($referenceNumber5 = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber5) && !is_string($referenceNumber5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber5, true), gettype($referenceNumber5)), __LINE__);
        }
        $this->ReferenceNumber5 = $referenceNumber5;
        return $this;
    }
    /**
     * Get SpecialInstructions1 value
     * @return string|null
     */
    public function getSpecialInstructions1()
    {
        return $this->SpecialInstructions1;
    }
    /**
     * Set SpecialInstructions1 value
     * @param string $specialInstructions1
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setSpecialInstructions1($specialInstructions1 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions1) && !is_string($specialInstructions1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstructions1, true), gettype($specialInstructions1)), __LINE__);
        }
        $this->SpecialInstructions1 = $specialInstructions1;
        return $this;
    }
    /**
     * Get SpecialInstructions2 value
     * @return string|null
     */
    public function getSpecialInstructions2()
    {
        return $this->SpecialInstructions2;
    }
    /**
     * Set SpecialInstructions2 value
     * @param string $specialInstructions2
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setSpecialInstructions2($specialInstructions2 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions2) && !is_string($specialInstructions2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstructions2, true), gettype($specialInstructions2)), __LINE__);
        }
        $this->SpecialInstructions2 = $specialInstructions2;
        return $this;
    }
    /**
     * Get SpecialInstructions3 value
     * @return string|null
     */
    public function getSpecialInstructions3()
    {
        return $this->SpecialInstructions3;
    }
    /**
     * Set SpecialInstructions3 value
     * @param string $specialInstructions3
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setSpecialInstructions3($specialInstructions3 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions3) && !is_string($specialInstructions3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstructions3, true), gettype($specialInstructions3)), __LINE__);
        }
        $this->SpecialInstructions3 = $specialInstructions3;
        return $this;
    }
    /**
     * Get SpecialInstructions4 value
     * @return string|null
     */
    public function getSpecialInstructions4()
    {
        return $this->SpecialInstructions4;
    }
    /**
     * Set SpecialInstructions4 value
     * @param string $specialInstructions4
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setSpecialInstructions4($specialInstructions4 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstructions4) && !is_string($specialInstructions4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstructions4, true), gettype($specialInstructions4)), __LINE__);
        }
        $this->SpecialInstructions4 = $specialInstructions4;
        return $this;
    }
    /**
     * Get InBoundContact value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Contact|null
     */
    public function getInBoundContact()
    {
        return $this->InBoundContact;
    }
    /**
     * Set InBoundContact value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Contact $inBoundContact
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setInBoundContact(\app\Service\ShipmentHandler\ParcelForce\StructType\Contact $inBoundContact = null)
    {
        $this->InBoundContact = $inBoundContact;
        return $this;
    }
    /**
     * Get InBoundAddress value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Address|null
     */
    public function getInBoundAddress()
    {
        return $this->InBoundAddress;
    }
    /**
     * Set InBoundAddress value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $inBoundAddress
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setInBoundAddress(\app\Service\ShipmentHandler\ParcelForce\StructType\Address $inBoundAddress = null)
    {
        $this->InBoundAddress = $inBoundAddress;
        return $this;
    }
    /**
     * Get InBoundDetails value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\InBoundDetails|null
     */
    public function getInBoundDetails()
    {
        return $this->InBoundDetails;
    }
    /**
     * Set InBoundDetails value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\InBoundDetails $inBoundDetails
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setInBoundDetails(\app\Service\ShipmentHandler\ParcelForce\StructType\InBoundDetails $inBoundDetails = null)
    {
        $this->InBoundDetails = $inBoundDetails;
        return $this;
    }
    /**
     * Get ExchangeInstructions1 value
     * @return string|null
     */
    public function getExchangeInstructions1()
    {
        return $this->ExchangeInstructions1;
    }
    /**
     * Set ExchangeInstructions1 value
     * @param string $exchangeInstructions1
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setExchangeInstructions1($exchangeInstructions1 = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeInstructions1) && !is_string($exchangeInstructions1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeInstructions1, true), gettype($exchangeInstructions1)), __LINE__);
        }
        $this->ExchangeInstructions1 = $exchangeInstructions1;
        return $this;
    }
    /**
     * Get ExchangeInstructions2 value
     * @return string|null
     */
    public function getExchangeInstructions2()
    {
        return $this->ExchangeInstructions2;
    }
    /**
     * Set ExchangeInstructions2 value
     * @param string $exchangeInstructions2
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setExchangeInstructions2($exchangeInstructions2 = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeInstructions2) && !is_string($exchangeInstructions2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeInstructions2, true), gettype($exchangeInstructions2)), __LINE__);
        }
        $this->ExchangeInstructions2 = $exchangeInstructions2;
        return $this;
    }
    /**
     * Get ExchangeInstructions3 value
     * @return string|null
     */
    public function getExchangeInstructions3()
    {
        return $this->ExchangeInstructions3;
    }
    /**
     * Set ExchangeInstructions3 value
     * @param string $exchangeInstructions3
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setExchangeInstructions3($exchangeInstructions3 = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeInstructions3) && !is_string($exchangeInstructions3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeInstructions3, true), gettype($exchangeInstructions3)), __LINE__);
        }
        $this->ExchangeInstructions3 = $exchangeInstructions3;
        return $this;
    }
    /**
     * Get ConsignmentHandling value
     * @return bool|null
     */
    public function getConsignmentHandling()
    {
        return $this->ConsignmentHandling;
    }
    /**
     * Set ConsignmentHandling value
     * @param bool $consignmentHandling
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public function setConsignmentHandling($consignmentHandling = null)
    {
        // validation for constraint: boolean
        if (!is_null($consignmentHandling) && !is_bool($consignmentHandling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($consignmentHandling, true), gettype($consignmentHandling)), __LINE__);
        }
        $this->ConsignmentHandling = $consignmentHandling;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\RequestedShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
