<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostcodeExclusion StructType
 * @subpackage Structs
 */
class PostcodeExclusion extends AbstractStructBase
{
    /**
     * The DeliveryPostcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryPostcode;
    /**
     * The CollectionPostcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CollectionPostcode;
    /**
     * The Departments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Departments
     */
    public $Departments;
    /**
     * Constructor method for PostcodeExclusion
     * @uses PostcodeExclusion::setDeliveryPostcode()
     * @uses PostcodeExclusion::setCollectionPostcode()
     * @uses PostcodeExclusion::setDepartments()
     * @param string $deliveryPostcode
     * @param string $collectionPostcode
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Departments $departments
     */
    public function __construct($deliveryPostcode = null, $collectionPostcode = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Departments $departments = null)
    {
        $this
            ->setDeliveryPostcode($deliveryPostcode)
            ->setCollectionPostcode($collectionPostcode)
            ->setDepartments($departments);
    }
    /**
     * Get DeliveryPostcode value
     * @return string|null
     */
    public function getDeliveryPostcode()
    {
        return $this->DeliveryPostcode;
    }
    /**
     * Set DeliveryPostcode value
     * @param string $deliveryPostcode
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostcodeExclusion
     */
    public function setDeliveryPostcode($deliveryPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryPostcode) && !is_string($deliveryPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryPostcode, true), gettype($deliveryPostcode)), __LINE__);
        }
        $this->DeliveryPostcode = $deliveryPostcode;
        return $this;
    }
    /**
     * Get CollectionPostcode value
     * @return string|null
     */
    public function getCollectionPostcode()
    {
        return $this->CollectionPostcode;
    }
    /**
     * Set CollectionPostcode value
     * @param string $collectionPostcode
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostcodeExclusion
     */
    public function setCollectionPostcode($collectionPostcode = null)
    {
        // validation for constraint: string
        if (!is_null($collectionPostcode) && !is_string($collectionPostcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectionPostcode, true), gettype($collectionPostcode)), __LINE__);
        }
        $this->CollectionPostcode = $collectionPostcode;
        return $this;
    }
    /**
     * Get Departments value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Departments|null
     */
    public function getDepartments()
    {
        return $this->Departments;
    }
    /**
     * Set Departments value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Departments $departments
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostcodeExclusion
     */
    public function setDepartments(\app\Service\ShipmentHandler\ParcelForce\StructType\Departments $departments = null)
    {
        $this->Departments = $departments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostcodeExclusion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
