<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostOffice StructType
 * @subpackage Structs
 */
class PostOffice extends AbstractStructBase
{
    /**
     * The PostOfficeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostOfficeID;
    /**
     * The Business
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Business;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Address
     */
    public $Address;
    /**
     * The OpeningHours
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\OpeningHours
     */
    public $OpeningHours;
    /**
     * The Distance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Distance;
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Availability;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Position
     */
    public $Position;
    /**
     * The BookingReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingReference;
    /**
     * Constructor method for PostOffice
     * @uses PostOffice::setPostOfficeID()
     * @uses PostOffice::setBusiness()
     * @uses PostOffice::setAddress()
     * @uses PostOffice::setOpeningHours()
     * @uses PostOffice::setDistance()
     * @uses PostOffice::setAvailability()
     * @uses PostOffice::setPosition()
     * @uses PostOffice::setBookingReference()
     * @param string $postOfficeID
     * @param string $business
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $address
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\OpeningHours $openingHours
     * @param float $distance
     * @param bool $availability
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Position $position
     * @param string $bookingReference
     */
    public function __construct($postOfficeID = null, $business = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Address $address = null, \app\Service\ShipmentHandler\ParcelForce\StructType\OpeningHours $openingHours = null, $distance = null, $availability = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Position $position = null, $bookingReference = null)
    {
        $this
            ->setPostOfficeID($postOfficeID)
            ->setBusiness($business)
            ->setAddress($address)
            ->setOpeningHours($openingHours)
            ->setDistance($distance)
            ->setAvailability($availability)
            ->setPosition($position)
            ->setBookingReference($bookingReference);
    }
    /**
     * Get PostOfficeID value
     * @return string|null
     */
    public function getPostOfficeID()
    {
        return $this->PostOfficeID;
    }
    /**
     * Set PostOfficeID value
     * @param string $postOfficeID
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice
     */
    public function setPostOfficeID($postOfficeID = null)
    {
        // validation for constraint: string
        if (!is_null($postOfficeID) && !is_string($postOfficeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postOfficeID, true), gettype($postOfficeID)), __LINE__);
        }
        $this->PostOfficeID = $postOfficeID;
        return $this;
    }
    /**
     * Get Business value
     * @return string|null
     */
    public function getBusiness()
    {
        return $this->Business;
    }
    /**
     * Set Business value
     * @param string $business
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice
     */
    public function setBusiness($business = null)
    {
        // validation for constraint: string
        if (!is_null($business) && !is_string($business)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business, true), gettype($business)), __LINE__);
        }
        $this->Business = $business;
        return $this;
    }
    /**
     * Get Address value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $address
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice
     */
    public function setAddress(\app\Service\ShipmentHandler\ParcelForce\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get OpeningHours value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\OpeningHours|null
     */
    public function getOpeningHours()
    {
        return $this->OpeningHours;
    }
    /**
     * Set OpeningHours value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\OpeningHours $openingHours
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice
     */
    public function setOpeningHours(\app\Service\ShipmentHandler\ParcelForce\StructType\OpeningHours $openingHours = null)
    {
        $this->OpeningHours = $openingHours;
        return $this;
    }
    /**
     * Get Distance value
     * @return float|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param float $distance
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: float
        if (!is_null($distance) && !(is_float($distance) || is_numeric($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Availability value
     * @return bool|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param bool $availability
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: boolean
        if (!is_null($availability) && !is_bool($availability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availability, true), gettype($availability)), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get Position value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Position $position
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice
     */
    public function setPosition(\app\Service\ShipmentHandler\ParcelForce\StructType\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get BookingReference value
     * @return string|null
     */
    public function getBookingReference()
    {
        return $this->BookingReference;
    }
    /**
     * Set BookingReference value
     * @param string $bookingReference
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice
     */
    public function setBookingReference($bookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReference) && !is_string($bookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingReference, true), gettype($bookingReference)), __LINE__);
        }
        $this->BookingReference = $bookingReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PostOffice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
