<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NominatedDeliveryDateList StructType
 * @subpackage Structs
 */
class NominatedDeliveryDateList extends AbstractStructBase
{
    /**
     * The NominatedDeliveryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $NominatedDeliveryDate;
    /**
     * Constructor method for NominatedDeliveryDateList
     * @uses NominatedDeliveryDateList::setNominatedDeliveryDate()
     * @param string[] $nominatedDeliveryDate
     */
    public function __construct(array $nominatedDeliveryDate = array())
    {
        $this
            ->setNominatedDeliveryDate($nominatedDeliveryDate);
    }
    /**
     * Get NominatedDeliveryDate value
     * @return string[]|null
     */
    public function getNominatedDeliveryDate()
    {
        return $this->NominatedDeliveryDate;
    }
    /**
     * This method is responsible for validating the values passed to the setNominatedDeliveryDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNominatedDeliveryDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNominatedDeliveryDateForArrayConstraintsFromSetNominatedDeliveryDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nominatedDeliveryDateListNominatedDeliveryDateItem) {
            // validation for constraint: itemType
            if (!is_string($nominatedDeliveryDateListNominatedDeliveryDateItem)) {
                $invalidValues[] = is_object($nominatedDeliveryDateListNominatedDeliveryDateItem) ? get_class($nominatedDeliveryDateListNominatedDeliveryDateItem) : sprintf('%s(%s)', gettype($nominatedDeliveryDateListNominatedDeliveryDateItem), var_export($nominatedDeliveryDateListNominatedDeliveryDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NominatedDeliveryDate property can only contain items of type date, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NominatedDeliveryDate value
     * @throws \InvalidArgumentException
     * @param string[] $nominatedDeliveryDate
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDateList
     */
    public function setNominatedDeliveryDate(array $nominatedDeliveryDate = array())
    {
        // validation for constraint: array
        if ('' !== ($nominatedDeliveryDateArrayErrorMessage = self::validateNominatedDeliveryDateForArrayConstraintsFromSetNominatedDeliveryDate($nominatedDeliveryDate))) {
            throw new \InvalidArgumentException($nominatedDeliveryDateArrayErrorMessage, __LINE__);
        }
        $this->NominatedDeliveryDate = $nominatedDeliveryDate;
        return $this;
    }
    /**
     * Add item to NominatedDeliveryDate value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDateList
     */
    public function addToNominatedDeliveryDate($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NominatedDeliveryDate property can only contain items of type date, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NominatedDeliveryDate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDateList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
