<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Department StructType
 * @subpackage Structs
 */
class Department extends AbstractStructBase
{
    /**
     * The DepartmentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $DepartmentID;
    /**
     * The ServiceCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes[]
     */
    public $ServiceCodes;
    /**
     * The NominatedDeliveryDateList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDateList
     */
    public $NominatedDeliveryDateList;
    /**
     * Constructor method for Department
     * @uses Department::setDepartmentID()
     * @uses Department::setServiceCodes()
     * @uses Department::setNominatedDeliveryDateList()
     * @param int[] $departmentID
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes[] $serviceCodes
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDateList $nominatedDeliveryDateList
     */
    public function __construct(array $departmentID = array(), array $serviceCodes = array(), \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDateList $nominatedDeliveryDateList = null)
    {
        $this
            ->setDepartmentID($departmentID)
            ->setServiceCodes($serviceCodes)
            ->setNominatedDeliveryDateList($nominatedDeliveryDateList);
    }
    /**
     * Get DepartmentID value
     * @return int[]|null
     */
    public function getDepartmentID()
    {
        return $this->DepartmentID;
    }
    /**
     * This method is responsible for validating the values passed to the setDepartmentID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepartmentID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepartmentIDForArrayConstraintsFromSetDepartmentID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $departmentDepartmentIDItem) {
            // validation for constraint: itemType
            if (!(is_int($departmentDepartmentIDItem) || ctype_digit($departmentDepartmentIDItem))) {
                $invalidValues[] = is_object($departmentDepartmentIDItem) ? get_class($departmentDepartmentIDItem) : sprintf('%s(%s)', gettype($departmentDepartmentIDItem), var_export($departmentDepartmentIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DepartmentID property can only contain items of type integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DepartmentID value
     * @throws \InvalidArgumentException
     * @param int[] $departmentID
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Department
     */
    public function setDepartmentID(array $departmentID = array())
    {
        // validation for constraint: array
        if ('' !== ($departmentIDArrayErrorMessage = self::validateDepartmentIDForArrayConstraintsFromSetDepartmentID($departmentID))) {
            throw new \InvalidArgumentException($departmentIDArrayErrorMessage, __LINE__);
        }
        $this->DepartmentID = $departmentID;
        return $this;
    }
    /**
     * Add item to DepartmentID value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Department
     */
    public function addToDepartmentID($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The DepartmentID property can only contain items of type integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DepartmentID[] = $item;
        return $this;
    }
    /**
     * Get ServiceCodes value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes[]|null
     */
    public function getServiceCodes()
    {
        return $this->ServiceCodes;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceCodes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceCodes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceCodesForArrayConstraintsFromSetServiceCodes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $departmentServiceCodesItem) {
            // validation for constraint: itemType
            if (!$departmentServiceCodesItem instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes) {
                $invalidValues[] = is_object($departmentServiceCodesItem) ? get_class($departmentServiceCodesItem) : sprintf('%s(%s)', gettype($departmentServiceCodesItem), var_export($departmentServiceCodesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceCodes property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceCodes value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes[] $serviceCodes
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Department
     */
    public function setServiceCodes(array $serviceCodes = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceCodesArrayErrorMessage = self::validateServiceCodesForArrayConstraintsFromSetServiceCodes($serviceCodes))) {
            throw new \InvalidArgumentException($serviceCodesArrayErrorMessage, __LINE__);
        }
        $this->ServiceCodes = $serviceCodes;
        return $this;
    }
    /**
     * Add item to ServiceCodes value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes $item
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Department
     */
    public function addToServiceCodes(\app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes) {
            throw new \InvalidArgumentException(sprintf('The ServiceCodes property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\ServiceCodes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceCodes[] = $item;
        return $this;
    }
    /**
     * Get NominatedDeliveryDateList value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDateList|null
     */
    public function getNominatedDeliveryDateList()
    {
        return $this->NominatedDeliveryDateList;
    }
    /**
     * Set NominatedDeliveryDateList value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDateList $nominatedDeliveryDateList
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Department
     */
    public function setNominatedDeliveryDateList(\app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDateList $nominatedDeliveryDateList = null)
    {
        $this->NominatedDeliveryDateList = $nominatedDeliveryDateList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Department
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
