<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryOptions StructType
 * @subpackage Structs
 */
class DeliveryOptions extends AbstractStructBase
{
    /**
     * The ConvenientCollect
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\ConvenientCollect
     */
    public $ConvenientCollect;
    /**
     * The IRTS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IRTS;
    /**
     * The Letterbox
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Letterbox;
    /**
     * The SpecifiedPostOffice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice
     */
    public $SpecifiedPostOffice;
    /**
     * The SpecifiedNeighbour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpecifiedNeighbour;
    /**
     * The SafePlace
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SafePlace;
    /**
     * The PIN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PIN;
    /**
     * The NamedRecipient
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $NamedRecipient;
    /**
     * The AddressOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AddressOnly;
    /**
     * The NominatedDeliveryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NominatedDeliveryDate;
    /**
     * The PersonalParcel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PersonalParcel;
    /**
     * Constructor method for DeliveryOptions
     * @uses DeliveryOptions::setConvenientCollect()
     * @uses DeliveryOptions::setIRTS()
     * @uses DeliveryOptions::setLetterbox()
     * @uses DeliveryOptions::setSpecifiedPostOffice()
     * @uses DeliveryOptions::setSpecifiedNeighbour()
     * @uses DeliveryOptions::setSafePlace()
     * @uses DeliveryOptions::setPIN()
     * @uses DeliveryOptions::setNamedRecipient()
     * @uses DeliveryOptions::setAddressOnly()
     * @uses DeliveryOptions::setNominatedDeliveryDate()
     * @uses DeliveryOptions::setPersonalParcel()
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ConvenientCollect $convenientCollect
     * @param bool $iRTS
     * @param bool $letterbox
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice $specifiedPostOffice
     * @param string $specifiedNeighbour
     * @param string $safePlace
     * @param int $pIN
     * @param bool $namedRecipient
     * @param bool $addressOnly
     * @param string $nominatedDeliveryDate
     * @param string $personalParcel
     */
    public function __construct(\app\Service\ShipmentHandler\ParcelForce\StructType\ConvenientCollect $convenientCollect = null, $iRTS = null, $letterbox = null, \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice $specifiedPostOffice = null, $specifiedNeighbour = null, $safePlace = null, $pIN = null, $namedRecipient = null, $addressOnly = null, $nominatedDeliveryDate = null, $personalParcel = null)
    {
        $this
            ->setConvenientCollect($convenientCollect)
            ->setIRTS($iRTS)
            ->setLetterbox($letterbox)
            ->setSpecifiedPostOffice($specifiedPostOffice)
            ->setSpecifiedNeighbour($specifiedNeighbour)
            ->setSafePlace($safePlace)
            ->setPIN($pIN)
            ->setNamedRecipient($namedRecipient)
            ->setAddressOnly($addressOnly)
            ->setNominatedDeliveryDate($nominatedDeliveryDate)
            ->setPersonalParcel($personalParcel);
    }
    /**
     * Get ConvenientCollect value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ConvenientCollect|null
     */
    public function getConvenientCollect()
    {
        return $this->ConvenientCollect;
    }
    /**
     * Set ConvenientCollect value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ConvenientCollect $convenientCollect
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setConvenientCollect(\app\Service\ShipmentHandler\ParcelForce\StructType\ConvenientCollect $convenientCollect = null)
    {
        $this->ConvenientCollect = $convenientCollect;
        return $this;
    }
    /**
     * Get IRTS value
     * @return bool|null
     */
    public function getIRTS()
    {
        return $this->IRTS;
    }
    /**
     * Set IRTS value
     * @param bool $iRTS
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setIRTS($iRTS = null)
    {
        // validation for constraint: boolean
        if (!is_null($iRTS) && !is_bool($iRTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iRTS, true), gettype($iRTS)), __LINE__);
        }
        $this->IRTS = $iRTS;
        return $this;
    }
    /**
     * Get Letterbox value
     * @return bool|null
     */
    public function getLetterbox()
    {
        return $this->Letterbox;
    }
    /**
     * Set Letterbox value
     * @param bool $letterbox
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setLetterbox($letterbox = null)
    {
        // validation for constraint: boolean
        if (!is_null($letterbox) && !is_bool($letterbox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($letterbox, true), gettype($letterbox)), __LINE__);
        }
        $this->Letterbox = $letterbox;
        return $this;
    }
    /**
     * Get SpecifiedPostOffice value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice|null
     */
    public function getSpecifiedPostOffice()
    {
        return $this->SpecifiedPostOffice;
    }
    /**
     * Set SpecifiedPostOffice value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice $specifiedPostOffice
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setSpecifiedPostOffice(\app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedPostOffice $specifiedPostOffice = null)
    {
        $this->SpecifiedPostOffice = $specifiedPostOffice;
        return $this;
    }
    /**
     * Get SpecifiedNeighbour value
     * @return string|null
     */
    public function getSpecifiedNeighbour()
    {
        return $this->SpecifiedNeighbour;
    }
    /**
     * Set SpecifiedNeighbour value
     * @param string $specifiedNeighbour
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setSpecifiedNeighbour($specifiedNeighbour = null)
    {
        // validation for constraint: string
        if (!is_null($specifiedNeighbour) && !is_string($specifiedNeighbour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specifiedNeighbour, true), gettype($specifiedNeighbour)), __LINE__);
        }
        $this->SpecifiedNeighbour = $specifiedNeighbour;
        return $this;
    }
    /**
     * Get SafePlace value
     * @return string|null
     */
    public function getSafePlace()
    {
        return $this->SafePlace;
    }
    /**
     * Set SafePlace value
     * @param string $safePlace
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setSafePlace($safePlace = null)
    {
        // validation for constraint: string
        if (!is_null($safePlace) && !is_string($safePlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($safePlace, true), gettype($safePlace)), __LINE__);
        }
        $this->SafePlace = $safePlace;
        return $this;
    }
    /**
     * Get PIN value
     * @return int|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param int $pIN
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: int
        if (!is_null($pIN) && !(is_int($pIN) || ctype_digit($pIN))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pIN, true), gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get NamedRecipient value
     * @return bool|null
     */
    public function getNamedRecipient()
    {
        return $this->NamedRecipient;
    }
    /**
     * Set NamedRecipient value
     * @param bool $namedRecipient
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setNamedRecipient($namedRecipient = null)
    {
        // validation for constraint: boolean
        if (!is_null($namedRecipient) && !is_bool($namedRecipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($namedRecipient, true), gettype($namedRecipient)), __LINE__);
        }
        $this->NamedRecipient = $namedRecipient;
        return $this;
    }
    /**
     * Get AddressOnly value
     * @return bool|null
     */
    public function getAddressOnly()
    {
        return $this->AddressOnly;
    }
    /**
     * Set AddressOnly value
     * @param bool $addressOnly
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setAddressOnly($addressOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressOnly) && !is_bool($addressOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressOnly, true), gettype($addressOnly)), __LINE__);
        }
        $this->AddressOnly = $addressOnly;
        return $this;
    }
    /**
     * Get NominatedDeliveryDate value
     * @return string|null
     */
    public function getNominatedDeliveryDate()
    {
        return $this->NominatedDeliveryDate;
    }
    /**
     * Set NominatedDeliveryDate value
     * @param string $nominatedDeliveryDate
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setNominatedDeliveryDate($nominatedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($nominatedDeliveryDate) && !is_string($nominatedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nominatedDeliveryDate, true), gettype($nominatedDeliveryDate)), __LINE__);
        }
        $this->NominatedDeliveryDate = $nominatedDeliveryDate;
        return $this;
    }
    /**
     * Get PersonalParcel value
     * @return string|null
     */
    public function getPersonalParcel()
    {
        return $this->PersonalParcel;
    }
    /**
     * Set PersonalParcel value
     * @param string $personalParcel
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public function setPersonalParcel($personalParcel = null)
    {
        // validation for constraint: string
        if (!is_null($personalParcel) && !is_string($personalParcel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personalParcel, true), gettype($personalParcel)), __LINE__);
        }
        $this->PersonalParcel = $personalParcel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DeliveryOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
