<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CCReserveRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ns:CCReserveRequest
 * @subpackage Structs
 */
class CCReserveRequest extends BaseRequest
{
    /**
     * The BookingReference
     * @var string
     */
    public $BookingReference;
    /**
     * Constructor method for CCReserveRequest
     * @uses CCReserveRequest::setBookingReference()
     * @param string $bookingReference
     */
    public function __construct($bookingReference = null)
    {
        $this
            ->setBookingReference($bookingReference);
    }
    /**
     * Get BookingReference value
     * @return string|null
     */
    public function getBookingReference()
    {
        return $this->BookingReference;
    }
    /**
     * Set BookingReference value
     * @param string $bookingReference
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CCReserveRequest
     */
    public function setBookingReference($bookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($bookingReference) && !is_string($bookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingReference, true), gettype($bookingReference)), __LINE__);
        }
        $this->BookingReference = $bookingReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CCReserveRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
