<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Barcodes StructType
 * @subpackage Structs
 */
class Barcodes extends AbstractStructBase
{
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Barcode[]
     */
    public $Barcode;
    /**
     * Constructor method for Barcodes
     * @uses Barcodes::setBarcode()
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Barcode[] $barcode
     */
    public function __construct(array $barcode = array())
    {
        $this
            ->setBarcode($barcode);
    }
    /**
     * Get Barcode value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Barcode[]|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * This method is responsible for validating the values passed to the setBarcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBarcode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBarcodeForArrayConstraintsFromSetBarcode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $barcodesBarcodeItem) {
            // validation for constraint: itemType
            if (!$barcodesBarcodeItem instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\Barcode) {
                $invalidValues[] = is_object($barcodesBarcodeItem) ? get_class($barcodesBarcodeItem) : sprintf('%s(%s)', gettype($barcodesBarcodeItem), var_export($barcodesBarcodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Barcode property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\Barcode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Barcode value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Barcode[] $barcode
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Barcodes
     */
    public function setBarcode(array $barcode = array())
    {
        // validation for constraint: array
        if ('' !== ($barcodeArrayErrorMessage = self::validateBarcodeForArrayConstraintsFromSetBarcode($barcode))) {
            throw new \InvalidArgumentException($barcodeArrayErrorMessage, __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Add item to Barcode value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Barcode $item
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Barcodes
     */
    public function addToBarcode(\app\Service\ShipmentHandler\ParcelForce\StructType\Barcode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\Barcode) {
            throw new \InvalidArgumentException(sprintf('The Barcode property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\Barcode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Barcode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Barcodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
