<?php

namespace app\Service\ShipmentHandler\ParcelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Find
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\FindRequest $findRequest
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\FindReply|bool
     */
    public function Find(\app\Service\ShipmentHandler\ParcelForce\StructType\FindRequest $findRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->Find($findRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\FindReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
