<?php

namespace app\Service\ShipmentHandler\ParcelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for CCR ServiceType
 * @subpackage Services
 */
class CCR extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CCReserve
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\CCReserveRequest $cCReserveRequest
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CCReserveReply|bool
     */
    public function CCReserve(\app\Service\ShipmentHandler\ParcelForce\StructType\CCReserveRequest $cCReserveRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CCReserve($cCReserveRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CCReserveReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
