<?php

namespace app\Service\ShipmentHandler\ParcelForce\EnumType;

/**
 * This class stands for AlertType EnumType
 * @subpackage Enumerations
 */
class AlertType
{
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'WARNING'
     * @return string 'WARNING'
     */
    const VALUE_WARNING = 'WARNING';
    /**
     * Constant for value 'NOTIFICATION'
     * @return string 'NOTIFICATION'
     */
    const VALUE_NOTIFICATION = 'NOTIFICATION';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_NOTIFICATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ERROR,
            self::VALUE_WARNING,
            self::VALUE_NOTIFICATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
