<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnShipmentRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ns:ReturnShipmentRequest
 * @subpackage Structs
 */
class ReturnShipmentRequest extends BaseRequest
{
    /**
     * The ShipmentNumber
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The CollectionTime
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\DateTimeRange
     */
    public $CollectionTime;
    /**
     * Constructor method for ReturnShipmentRequest
     * @uses ReturnShipmentRequest::setShipmentNumber()
     * @uses ReturnShipmentRequest::setCollectionTime()
     * @param string $shipmentNumber
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\DateTimeRange $collectionTime
     */
    public function __construct($shipmentNumber = null, \app\Service\ShipmentHandler\ParcelForce\StructType\DateTimeRange $collectionTime = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setCollectionTime($collectionTime);
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ReturnShipmentRequest
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get CollectionTime value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\DateTimeRange|null
     */
    public function getCollectionTime()
    {
        return $this->CollectionTime;
    }
    /**
     * Set CollectionTime value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\DateTimeRange $collectionTime
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ReturnShipmentRequest
     */
    public function setCollectionTime(\app\Service\ShipmentHandler\ParcelForce\StructType\DateTimeRange $collectionTime = null)
    {
        $this->CollectionTime = $collectionTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ReturnShipmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
