<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintLabelRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ns:PrintLabelRequest
 * @subpackage Structs
 */
class PrintLabelRequest extends BaseRequest
{
    /**
     * The ShipmentNumber
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The PrintFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PrintFormat;
    /**
     * The BarcodeFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BarcodeFormat;
    /**
     * The PrintType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PrintType;
    /**
     * Constructor method for PrintLabelRequest
     * @uses PrintLabelRequest::setShipmentNumber()
     * @uses PrintLabelRequest::setPrintFormat()
     * @uses PrintLabelRequest::setBarcodeFormat()
     * @uses PrintLabelRequest::setPrintType()
     * @param string $shipmentNumber
     * @param string $printFormat
     * @param string $barcodeFormat
     * @param string $printType
     */
    public function __construct($shipmentNumber = null, $printFormat = null, $barcodeFormat = null, $printType = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setPrintFormat($printFormat)
            ->setBarcodeFormat($barcodeFormat)
            ->setPrintType($printType);
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PrintLabelRequest
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get PrintFormat value
     * @return string|null
     */
    public function getPrintFormat()
    {
        return $this->PrintFormat;
    }
    /**
     * Set PrintFormat value
     * @param string $printFormat
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PrintLabelRequest
     */
    public function setPrintFormat($printFormat = null)
    {
        // validation for constraint: string
        if (!is_null($printFormat) && !is_string($printFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printFormat, true), gettype($printFormat)), __LINE__);
        }
        $this->PrintFormat = $printFormat;
        return $this;
    }
    /**
     * Get BarcodeFormat value
     * @return string|null
     */
    public function getBarcodeFormat()
    {
        return $this->BarcodeFormat;
    }
    /**
     * Set BarcodeFormat value
     * @param string $barcodeFormat
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PrintLabelRequest
     */
    public function setBarcodeFormat($barcodeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeFormat) && !is_string($barcodeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeFormat, true), gettype($barcodeFormat)), __LINE__);
        }
        $this->BarcodeFormat = $barcodeFormat;
        return $this;
    }
    /**
     * Get PrintType value
     * @return string|null
     */
    public function getPrintType()
    {
        return $this->PrintType;
    }
    /**
     * Set PrintType value
     * @uses \app\Service\ShipmentHandler\ParcelForce\EnumType\PrintType::valueIsValid()
     * @uses \app\Service\ShipmentHandler\ParcelForce\EnumType\PrintType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printType
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PrintLabelRequest
     */
    public function setPrintType($printType = null)
    {
        // validation for constraint: enumeration
        if (!\app\Service\ShipmentHandler\ParcelForce\EnumType\PrintType::valueIsValid($printType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \app\Service\ShipmentHandler\ParcelForce\EnumType\PrintType', is_array($printType) ? implode(', ', $printType) : var_export($printType, true), implode(', ', \app\Service\ShipmentHandler\ParcelForce\EnumType\PrintType::getValidValues())), __LINE__);
        }
        $this->PrintType = $printType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PrintLabelRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
