<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintDocumentRequest StructType
 * Meta informations extracted from the WSDL
 * - type: ns:PrintDocumentRequest
 * @subpackage Structs
 */
class PrintDocumentRequest extends BaseRequest
{
    /**
     * The ShipmentNumber
     * @var string
     */
    public $ShipmentNumber;
    /**
     * The DocumentType
     * @var int
     */
    public $DocumentType;
    /**
     * The PrintFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PrintFormat;
    /**
     * Constructor method for PrintDocumentRequest
     * @uses PrintDocumentRequest::setShipmentNumber()
     * @uses PrintDocumentRequest::setDocumentType()
     * @uses PrintDocumentRequest::setPrintFormat()
     * @param string $shipmentNumber
     * @param int $documentType
     * @param string $printFormat
     */
    public function __construct($shipmentNumber = null, $documentType = null, $printFormat = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setDocumentType($documentType)
            ->setPrintFormat($printFormat);
    }
    /**
     * Get ShipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param string $shipmentNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PrintDocumentRequest
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return int|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param int $documentType
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PrintDocumentRequest
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: int
        if (!is_null($documentType) && !(is_int($documentType) || ctype_digit($documentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get PrintFormat value
     * @return string|null
     */
    public function getPrintFormat()
    {
        return $this->PrintFormat;
    }
    /**
     * Set PrintFormat value
     * @param string $printFormat
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PrintDocumentRequest
     */
    public function setPrintFormat($printFormat = null)
    {
        // validation for constraint: string
        if (!is_null($printFormat) && !is_string($printFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printFormat, true), gettype($printFormat)), __LINE__);
        }
        $this->PrintFormat = $printFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PrintDocumentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
