<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PAF StructType
 * @subpackage Structs
 */
class PAF extends AbstractStructBase
{
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Postcode;
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Count;
    /**
     * The SpecifiedNeighbour
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour[]
     */
    public $SpecifiedNeighbour;
    /**
     * Constructor method for PAF
     * @uses PAF::setPostcode()
     * @uses PAF::setCount()
     * @uses PAF::setSpecifiedNeighbour()
     * @param string $postcode
     * @param int $count
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour[] $specifiedNeighbour
     */
    public function __construct($postcode = null, $count = null, array $specifiedNeighbour = array())
    {
        $this
            ->setPostcode($postcode)
            ->setCount($count)
            ->setSpecifiedNeighbour($specifiedNeighbour);
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PAF
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get Count value
     * @return int|null
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PAF
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get SpecifiedNeighbour value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour[]|null
     */
    public function getSpecifiedNeighbour()
    {
        return $this->SpecifiedNeighbour;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecifiedNeighbour method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecifiedNeighbour method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecifiedNeighbourForArrayConstraintsFromSetSpecifiedNeighbour(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pAFSpecifiedNeighbourItem) {
            // validation for constraint: itemType
            if (!$pAFSpecifiedNeighbourItem instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour) {
                $invalidValues[] = is_object($pAFSpecifiedNeighbourItem) ? get_class($pAFSpecifiedNeighbourItem) : sprintf('%s(%s)', gettype($pAFSpecifiedNeighbourItem), var_export($pAFSpecifiedNeighbourItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecifiedNeighbour property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecifiedNeighbour value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour[] $specifiedNeighbour
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PAF
     */
    public function setSpecifiedNeighbour(array $specifiedNeighbour = array())
    {
        // validation for constraint: array
        if ('' !== ($specifiedNeighbourArrayErrorMessage = self::validateSpecifiedNeighbourForArrayConstraintsFromSetSpecifiedNeighbour($specifiedNeighbour))) {
            throw new \InvalidArgumentException($specifiedNeighbourArrayErrorMessage, __LINE__);
        }
        $this->SpecifiedNeighbour = $specifiedNeighbour;
        return $this;
    }
    /**
     * Add item to SpecifiedNeighbour value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour $item
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PAF
     */
    public function addToSpecifiedNeighbour(\app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour) {
            throw new \InvalidArgumentException(sprintf('The SpecifiedNeighbour property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecifiedNeighbour[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\PAF
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
