<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NominatedDeliveryDates StructType
 * @subpackage Structs
 */
class NominatedDeliveryDates extends AbstractStructBase
{
    /**
     * The ServiceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceCode;
    /**
     * The Departments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Departments
     */
    public $Departments;
    /**
     * Constructor method for NominatedDeliveryDates
     * @uses NominatedDeliveryDates::setServiceCode()
     * @uses NominatedDeliveryDates::setDepartments()
     * @param string $serviceCode
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Departments $departments
     */
    public function __construct($serviceCode = null, \app\Service\ShipmentHandler\ParcelForce\StructType\Departments $departments = null)
    {
        $this
            ->setServiceCode($serviceCode)
            ->setDepartments($departments);
    }
    /**
     * Get ServiceCode value
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->ServiceCode;
    }
    /**
     * Set ServiceCode value
     * @param string $serviceCode
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDates
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCode) && !is_string($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCode, true), gettype($serviceCode)), __LINE__);
        }
        $this->ServiceCode = $serviceCode;
        return $this;
    }
    /**
     * Get Departments value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Departments|null
     */
    public function getDepartments()
    {
        return $this->Departments;
    }
    /**
     * Set Departments value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Departments $departments
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDates
     */
    public function setDepartments(\app\Service\ShipmentHandler\ParcelForce\StructType\Departments $departments = null)
    {
        $this->Departments = $departments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\NominatedDeliveryDates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
