<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HazardousGood StructType
 * @subpackage Structs
 */
class HazardousGood extends AbstractStructBase
{
    /**
     * The LQDGUNCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LQDGUNCode;
    /**
     * The LQDGDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LQDGDescription;
    /**
     * The LQDGVolume
     * Meta informations extracted from the WSDL
     * - base: xs:decimal
     * - minOccurs: 0
     * @var float
     */
    public $LQDGVolume;
    /**
     * The Firearms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Firearms;
    /**
     * Constructor method for HazardousGood
     * @uses HazardousGood::setLQDGUNCode()
     * @uses HazardousGood::setLQDGDescription()
     * @uses HazardousGood::setLQDGVolume()
     * @uses HazardousGood::setFirearms()
     * @param string $lQDGUNCode
     * @param string $lQDGDescription
     * @param float $lQDGVolume
     * @param string $firearms
     */
    public function __construct($lQDGUNCode = null, $lQDGDescription = null, $lQDGVolume = null, $firearms = null)
    {
        $this
            ->setLQDGUNCode($lQDGUNCode)
            ->setLQDGDescription($lQDGDescription)
            ->setLQDGVolume($lQDGVolume)
            ->setFirearms($firearms);
    }
    /**
     * Get LQDGUNCode value
     * @return string|null
     */
    public function getLQDGUNCode()
    {
        return $this->LQDGUNCode;
    }
    /**
     * Set LQDGUNCode value
     * @param string $lQDGUNCode
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGood
     */
    public function setLQDGUNCode($lQDGUNCode = null)
    {
        // validation for constraint: string
        if (!is_null($lQDGUNCode) && !is_string($lQDGUNCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lQDGUNCode, true), gettype($lQDGUNCode)), __LINE__);
        }
        $this->LQDGUNCode = $lQDGUNCode;
        return $this;
    }
    /**
     * Get LQDGDescription value
     * @return string|null
     */
    public function getLQDGDescription()
    {
        return $this->LQDGDescription;
    }
    /**
     * Set LQDGDescription value
     * @param string $lQDGDescription
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGood
     */
    public function setLQDGDescription($lQDGDescription = null)
    {
        // validation for constraint: string
        if (!is_null($lQDGDescription) && !is_string($lQDGDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lQDGDescription, true), gettype($lQDGDescription)), __LINE__);
        }
        $this->LQDGDescription = $lQDGDescription;
        return $this;
    }
    /**
     * Get LQDGVolume value
     * @return float|null
     */
    public function getLQDGVolume()
    {
        return $this->LQDGVolume;
    }
    /**
     * Set LQDGVolume value
     * @param float $lQDGVolume
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGood
     */
    public function setLQDGVolume($lQDGVolume = null)
    {
        // validation for constraint: float
        if (!is_null($lQDGVolume) && !(is_float($lQDGVolume) || is_numeric($lQDGVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lQDGVolume, true), gettype($lQDGVolume)), __LINE__);
        }
        $this->LQDGVolume = $lQDGVolume;
        return $this;
    }
    /**
     * Get Firearms value
     * @return string|null
     */
    public function getFirearms()
    {
        return $this->Firearms;
    }
    /**
     * Set Firearms value
     * @param string $firearms
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGood
     */
    public function setFirearms($firearms = null)
    {
        // validation for constraint: string
        if (!is_null($firearms) && !is_string($firearms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firearms, true), gettype($firearms)), __LINE__);
        }
        $this->Firearms = $firearms;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\HazardousGood
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
