<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompletedManifestInfo StructType
 * @subpackage Structs
 */
class CompletedManifestInfo extends AbstractStructBase
{
    /**
     * The DepartmentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $DepartmentId;
    /**
     * The ManifestNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ManifestNumber;
    /**
     * The ManifestType
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $ManifestType;
    /**
     * The TotalShipmentCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $TotalShipmentCount;
    /**
     * The ManifestShipments
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\ManifestShipments
     */
    public $ManifestShipments;
    /**
     * Constructor method for CompletedManifestInfo
     * @uses CompletedManifestInfo::setDepartmentId()
     * @uses CompletedManifestInfo::setManifestNumber()
     * @uses CompletedManifestInfo::setManifestType()
     * @uses CompletedManifestInfo::setTotalShipmentCount()
     * @uses CompletedManifestInfo::setManifestShipments()
     * @param int $departmentId
     * @param string $manifestNumber
     * @param string $manifestType
     * @param int $totalShipmentCount
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ManifestShipments $manifestShipments
     */
    public function __construct($departmentId = null, $manifestNumber = null, $manifestType = null, $totalShipmentCount = null, \app\Service\ShipmentHandler\ParcelForce\StructType\ManifestShipments $manifestShipments = null)
    {
        $this
            ->setDepartmentId($departmentId)
            ->setManifestNumber($manifestNumber)
            ->setManifestType($manifestType)
            ->setTotalShipmentCount($totalShipmentCount)
            ->setManifestShipments($manifestShipments);
    }
    /**
     * Get DepartmentId value
     * @return int
     */
    public function getDepartmentId()
    {
        return $this->DepartmentId;
    }
    /**
     * Set DepartmentId value
     * @param int $departmentId
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CompletedManifestInfo
     */
    public function setDepartmentId($departmentId = null)
    {
        // validation for constraint: int
        if (!is_null($departmentId) && !(is_int($departmentId) || ctype_digit($departmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($departmentId, true), gettype($departmentId)), __LINE__);
        }
        $this->DepartmentId = $departmentId;
        return $this;
    }
    /**
     * Get ManifestNumber value
     * @return string
     */
    public function getManifestNumber()
    {
        return $this->ManifestNumber;
    }
    /**
     * Set ManifestNumber value
     * @param string $manifestNumber
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CompletedManifestInfo
     */
    public function setManifestNumber($manifestNumber = null)
    {
        // validation for constraint: string
        if (!is_null($manifestNumber) && !is_string($manifestNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestNumber, true), gettype($manifestNumber)), __LINE__);
        }
        $this->ManifestNumber = $manifestNumber;
        return $this;
    }
    /**
     * Get ManifestType value
     * @return string
     */
    public function getManifestType()
    {
        return $this->ManifestType;
    }
    /**
     * Set ManifestType value
     * @param string $manifestType
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CompletedManifestInfo
     */
    public function setManifestType($manifestType = null)
    {
        // validation for constraint: string
        if (!is_null($manifestType) && !is_string($manifestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestType, true), gettype($manifestType)), __LINE__);
        }
        $this->ManifestType = $manifestType;
        return $this;
    }
    /**
     * Get TotalShipmentCount value
     * @return int
     */
    public function getTotalShipmentCount()
    {
        return $this->TotalShipmentCount;
    }
    /**
     * Set TotalShipmentCount value
     * @param int $totalShipmentCount
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CompletedManifestInfo
     */
    public function setTotalShipmentCount($totalShipmentCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalShipmentCount) && !(is_int($totalShipmentCount) || ctype_digit($totalShipmentCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalShipmentCount, true), gettype($totalShipmentCount)), __LINE__);
        }
        $this->TotalShipmentCount = $totalShipmentCount;
        return $this;
    }
    /**
     * Get ManifestShipments value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\ManifestShipments
     */
    public function getManifestShipments()
    {
        return $this->ManifestShipments;
    }
    /**
     * Set ManifestShipments value
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\ManifestShipments $manifestShipments
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CompletedManifestInfo
     */
    public function setManifestShipments(\app\Service\ShipmentHandler\ParcelForce\StructType\ManifestShipments $manifestShipments = null)
    {
        $this->ManifestShipments = $manifestShipments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CompletedManifestInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
