<?php

namespace app\Service\ShipmentHandler\ParcelForce\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelShipment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\CancelShipmentRequest $cancelShipmentRequest
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CancelShipmentReply|bool
     */
    public function CancelShipment(\app\Service\ShipmentHandler\ParcelForce\StructType\CancelShipmentRequest $cancelShipmentRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelShipment($cancelShipmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\CancelShipmentReply
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
