<?php

namespace app\Service\ShipmentHandler\ParcelForce\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecifiedNeighbour StructType
 * @subpackage Structs
 */
class SpecifiedNeighbour extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \app\Service\ShipmentHandler\ParcelForce\StructType\Address[]
     */
    public $Address;
    /**
     * Constructor method for SpecifiedNeighbour
     * @uses SpecifiedNeighbour::setAddress()
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address[] $address
     */
    public function __construct(array $address = array())
    {
        $this
            ->setAddress($address);
    }
    /**
     * Get Address value
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specifiedNeighbourAddressItem) {
            // validation for constraint: itemType
            if (!$specifiedNeighbourAddressItem instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\Address) {
                $invalidValues[] = is_object($specifiedNeighbourAddressItem) ? get_class($specifiedNeighbourAddressItem) : sprintf('%s(%s)', gettype($specifiedNeighbourAddressItem), var_export($specifiedNeighbourAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address[] $address
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \app\Service\ShipmentHandler\ParcelForce\StructType\Address $item
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour
     */
    public function addToAddress(\app\Service\ShipmentHandler\ParcelForce\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \app\Service\ShipmentHandler\ParcelForce\StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \app\Service\ShipmentHandler\ParcelForce\StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \app\Service\ShipmentHandler\ParcelForce\StructType\SpecifiedNeighbour
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
